/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.S3Object;

@Singleton
public class BindS3ObjectMetadataToRequest
implements Binder {
    protected final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindS3ObjectMetadataToRequest(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = Preconditions.checkNotNull(metadataPrefixer, "metadataPrefixer");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof S3Object, "this binder is only valid for S3Object!, not %s", input);
        Preconditions.checkNotNull(request, "request");
        S3Object s3Object = (S3Object)S3Object.class.cast(input);
        Preconditions.checkArgument(s3Object.getMetadata().getKey() != null, "s3Object.getMetadata().getKey() must be set!");
        Preconditions.checkArgument(s3Object.getPayload().getContentMetadata().getContentLength() != null, "contentLength must be set, streaming not supported");
        Preconditions.checkArgument(s3Object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L, "maximum size for put object is 5GB");
        ObjectMetadata.StorageClass storageClass = s3Object.getMetadata().getStorageClass();
        if (storageClass != ObjectMetadata.StorageClass.STANDARD) {
            request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-amz-storage-class", storageClass.toString())).build();
        }
        request = this.metadataPrefixer.bindToRequest(request, s3Object.getMetadata().getUserMetadata());
        return request;
    }
}

