/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.internal;

import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.CreationListener;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Errors;

class ProcessedBindingData {
    private final List<CreationListener> creationListeners = Lists.newArrayList();
    private final List<Runnable> uninitializedBindings = Lists.newArrayList();
    private final List<Runnable> delayedUninitializedBindings = Lists.newArrayList();

    ProcessedBindingData() {
    }

    void addCreationListener(CreationListener listener) {
        this.creationListeners.add(listener);
    }

    void addUninitializedBinding(Runnable runnable) {
        this.uninitializedBindings.add(runnable);
    }

    void addDelayedUninitializedBinding(Runnable runnable) {
        this.delayedUninitializedBindings.add(runnable);
    }

    void initializeBindings() {
        for (Runnable initializer : this.uninitializedBindings) {
            initializer.run();
        }
    }

    void runCreationListeners(Errors errors) {
        for (CreationListener creationListener : this.creationListeners) {
            creationListener.notify(errors);
        }
    }

    void initializeDelayedBindings() {
        for (Runnable initializer : this.delayedUninitializedBindings) {
            initializer.run();
        }
    }
}

