/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.LinkedHashMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.s3.domain.CannedAccessPolicy;

public class PutBucketOptions
extends BaseHttpRequestOptions {
    private CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
    private String headerTag;

    @Inject
    public void setHeaderTag(@Named(value="jclouds.aws.header.tag") String headerTag) {
        this.headerTag = headerTag;
    }

    @Override
    public Multimap<String, String> buildRequestHeaders() {
        Preconditions.checkState(this.headerTag != null, "headerTag should have been injected!");
        LinkedHashMultimap<String, String> returnVal = LinkedHashMultimap.create();
        for (Map.Entry entry : this.headers.entries()) {
            returnVal.put(((String)entry.getKey()).replace("aws", this.headerTag), (String)entry.getValue());
        }
        return returnVal;
    }

    public PutBucketOptions withBucketAcl(CannedAccessPolicy acl) {
        this.acl = Preconditions.checkNotNull(acl, "acl");
        if (!acl.equals((Object)CannedAccessPolicy.PRIVATE)) {
            this.replaceHeader("x-amz-acl", acl.toString());
        }
        return this;
    }

    public CannedAccessPolicy getAcl() {
        return this.acl;
    }

    public static class Builder {
        public static PutBucketOptions withBucketAcl(CannedAccessPolicy acl) {
            PutBucketOptions options = new PutBucketOptions();
            return options.withBucketAcl(acl);
        }
    }
}

