/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.Atomics;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.FactoryModuleBuilder;
import org.jclouds.Fallback;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.config.LocationModule;
import org.jclouds.proxy.ProxyForURI;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.config.SetCaller;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.rest.internal.TransformerForRequest;

public class RestModule
extends AbstractModule {
    protected final AtomicReference<AuthorizationException> authException = Atomics.newReference();

    protected void installLocations() {
        this.install(new LocationModule());
    }

    @Override
    protected void configure() {
        this.install(new SaxParserModule());
        this.install(new GsonModule());
        this.install(new SetCaller.Module());
        this.install(new FactoryModuleBuilder().build(BindToJsonPayloadWrappedWith.Factory.class));
        this.bind(new TypeLiteral<Function<HttpRequest, Function<HttpResponse, ?>>>(){}).to(TransformerForRequest.class);
        this.bind(new TypeLiteral<Fallback<Object>>(){}).to(MapHttp4xxCodesToExceptions.class);
        this.bind(new TypeLiteral<Function<Invocation, HttpRequest>>(){}).to(RestAnnotationProcessor.class);
        this.bind(IdentityFunction.class).toInstance(IdentityFunction.INSTANCE);
        this.bind(new TypeLiteral<AtomicReference<AuthorizationException>>(){}).toInstance(this.authException);
        this.bind(new TypeLiteral<Function<Predicate<String>, Map<String, String>>>(){}).to(FilterStringsBoundToInjectorByName.class);
        this.bind(new TypeLiteral<Function<URI, Proxy>>(){}).to(ProxyForURI.class);
        this.installLocations();
    }
}

