/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.features;

import java.util.List;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.HEAD;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v3.domain.Project;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Identity.class)
@Path(value="/projects")
public interface ProjectApi {
    @Named(value="projects:list")
    @GET
    @SelectJson(value={"projects"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Project> list();

    @Named(value="projects:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"project"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Project get(@PathParam(value="id") String var1);

    @Named(value="projects:create")
    @POST
    @SelectJson(value={"project"})
    @WrapWith(value="project")
    public Project create(@PayloadParam(value="name") String var1, @Nullable @PayloadParam(value="description") String var2, @PayloadParam(value="enabled") boolean var3, @PayloadParam(value="is_domain") boolean var4, @Nullable @PayloadParam(value="domain_id") String var5, @Nullable @PayloadParam(value="parent_id") String var6);

    @Named(value="projects:update")
    @PATCH
    @Path(value="/{id}")
    @SelectJson(value={"project"})
    public Project update(@PathParam(value="id") String var1, @WrapWith(value="project") Project var2);

    @Named(value="projects:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="projects:listTags")
    @GET
    @Path(value="/{projectId}/tags")
    @SelectJson(value={"tags"})
    public Set<String> listTags(@PathParam(value="projectId") String var1);

    @Named(value="projects:hasTag")
    @HEAD
    @Path(value="/{projectId}/tags/{tag}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean hasTag(@PathParam(value="projectId") String var1, @PathParam(value="tag") String var2);

    @Named(value="projects:addTag")
    @PUT
    @Path(value="/{projectId}/tags/{tag}")
    public void addTag(@PathParam(value="projectId") String var1, @PathParam(value="tag") String var2);

    @Named(value="projects:removeTag")
    @DELETE
    @Path(value="/{projectId}/tags/{tag}")
    public void removeTag(@PathParam(value="projectId") String var1, @PathParam(value="tag") String var2);

    @Named(value="projects:setTags")
    @PUT
    @Path(value="/{projectId}/tags")
    @MapBinder(value=BindToJsonPayload.class)
    public void setTags(@PathParam(value="projectId") String var1, @PayloadParam(value="tags") Set<String> var2);

    @Named(value="projects:removeTags")
    @DELETE
    @Path(value="/{projectId}/tags")
    public void removeAllTags(@PathParam(value="projectId") String var1);
}

