/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import java.net.URI;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;

@Singleton
public class JustProvider
implements Supplier<Set<? extends Location>> {
    private final String providerName;
    private final Supplier<URI> endpointSupplier;
    private final Set<String> isoCodesSupplier;

    @Inject
    public JustProvider(@Provider String providerName, @Provider Supplier<URI> endpointSupplier, @Iso3166 Set<String> isoCodesSupplier) {
        this.providerName = Preconditions.checkNotNull(providerName, "providerName");
        this.endpointSupplier = Preconditions.checkNotNull(endpointSupplier, "endpoint");
        this.isoCodesSupplier = Preconditions.checkNotNull(isoCodesSupplier, "isoCodes");
    }

    @Override
    public Set<? extends Location> get() {
        return ImmutableSet.of(new LocationBuilder().scope(LocationScope.PROVIDER).id(this.providerName).description(this.endpointSupplier.get().toASCIIString()).iso3166Codes(this.isoCodesSupplier).build());
    }
}

