/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.rest.Binder;

public class BindAzureBlobMetadataToMultipartRequest
implements Binder {
    private final AzureBlobToBlob azureBlob2Blob;
    private final BindUserMetadataToHeadersWithPrefix blobBinder;

    @Inject
    BindAzureBlobMetadataToMultipartRequest(AzureBlobToBlob azureBlob2Blob, BindUserMetadataToHeadersWithPrefix blobBinder) {
        this.azureBlob2Blob = azureBlob2Blob;
        this.blobBinder = blobBinder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String contentType;
        String contentLanguage;
        String contentEncoding;
        String contentDisposition;
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof AzureBlob, "this binder is only valid for AzureBlobs!");
        Preconditions.checkNotNull(request, "request");
        AzureBlob blob = (AzureBlob)AzureBlob.class.cast(input);
        Preconditions.checkArgument(blob.getPayload().getContentMetadata().getContentLength() != null && blob.getPayload().getContentMetadata().getContentLength() >= 0L, "size must be set");
        ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
        MutableContentMetadata contentMetadata = blob.getProperties().getContentMetadata();
        String cacheControl = contentMetadata.getCacheControl();
        if (cacheControl != null) {
            headers.put("x-ms-blob-cache-control", cacheControl);
        }
        if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
            headers.put("x-ms-blob-content-disposition", contentDisposition);
        }
        if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
            headers.put("x-ms-blob-content-encoding", contentEncoding);
        }
        if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
            headers.put("x-ms-blob-content-language", contentLanguage);
        }
        if ((contentType = contentMetadata.getContentType()) != null) {
            headers.put("x-ms-blob-content-type", contentType);
        }
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(headers.build()))).build();
        return this.blobBinder.bindToRequest(request, this.azureBlob2Blob.apply(blob));
    }
}

