/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.net.InetAddresses;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;

public class InetAddresses2 {
    public static boolean isPrivateIPAddress(String in) {
        return IsPrivateIPAddress.INSTANCE.apply(in);
    }

    @Singleton
    public static enum IsPrivateIPAddress implements Predicate<String>
    {
        INSTANCE;


        @Override
        public boolean apply(String in) {
            if (InetAddresses.isInetAddress(Preconditions.checkNotNull(in, "input address"))) {
                int second;
                if (in.indexOf("10.") == 0) {
                    return true;
                }
                if (in.indexOf("172.") == 0 && (second = Integer.parseInt(Iterables.get(Splitter.on('.').split(in), 1))) >= 16 && second <= 31) {
                    return true;
                }
                if (in.indexOf("192.168.") == 0) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "isPrivateIPAddress()";
        }
    }
}

