/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.functions.ParseObjectMetadataFromHeaders;

public class ParseObjectFromHeadersAndHttpContent
implements Function<HttpResponse, S3Object>,
InvocationContext<ParseObjectFromHeadersAndHttpContent> {
    private final ParseObjectMetadataFromHeaders metadataParser;
    private final S3Object.Factory objectProvider;

    @Inject
    public ParseObjectFromHeadersAndHttpContent(ParseObjectMetadataFromHeaders metadataParser, S3Object.Factory objectProvider) {
        this.metadataParser = metadataParser;
        this.objectProvider = objectProvider;
    }

    @Override
    public S3Object apply(HttpResponse from) {
        MutableObjectMetadata metadata = this.metadataParser.apply(from);
        S3Object object = this.objectProvider.create(metadata);
        object.getAllHeaders().putAll(from.getHeaders());
        object.setPayload(from.getPayload());
        return object;
    }

    @Override
    public ParseObjectFromHeadersAndHttpContent setContext(HttpRequest request) {
        this.metadataParser.setContext(request);
        return this;
    }
}

