/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.proxy.internal;

import java.net.Proxy;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.net.HostAndPort;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.proxy.ProxyConfig;

@Singleton
public class GuiceProxyConfig
implements ProxyConfig {
    @Inject(optional=true)
    @Named(value="jclouds.use-system-proxy")
    @Deprecated
    private boolean systemProxies = Boolean.parseBoolean(System.getProperty("java.net.useSystemProxies", "false"));
    @Inject(optional=true)
    @Named(value="jclouds.enable-jvm-proxy")
    private boolean jvmProxyEnabled = true;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-host")
    private String host;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-port")
    private Integer port;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-user")
    private String user;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-password")
    private String password;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-type")
    private Proxy.Type type = Proxy.Type.HTTP;
    @Inject(optional=true)
    @Named(value="jclouds.enable-ssl-proxy")
    private Boolean sslProxyEnabled = false;

    @Override
    public Optional<HostAndPort> getProxy() {
        if (Strings.isNullOrEmpty(this.host)) {
            return Optional.absent();
        }
        Integer port = this.port;
        if (port == null) {
            switch (this.type) {
                case HTTP: {
                    port = 80;
                    break;
                }
                case SOCKS: {
                    port = 1080;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " not supported");
                }
            }
        }
        return Optional.of(HostAndPort.fromParts(this.host, port));
    }

    @Override
    public Optional<Credentials> getCredentials() {
        if (this.user == null) {
            return Optional.absent();
        }
        return Optional.of(new Credentials(this.user, GuiceProxyConfig.checkNotEmpty(this.password, "set property %s for user %s", "jclouds.proxy-password", this.user)));
    }

    private static String checkNotEmpty(String nullableString, String message, Object ... args) {
        Preconditions.checkArgument(Strings.emptyToNull(nullableString) != null, message, args);
        return nullableString;
    }

    @Override
    public Proxy.Type getType() {
        return this.type;
    }

    @Override
    public boolean useSystem() {
        return this.systemProxies;
    }

    @Override
    public boolean isJvmProxyEnabled() {
        return this.jvmProxyEnabled;
    }

    public boolean isSslProxyEnabled() {
        return this.sslProxyEnabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("systemProxies", this.systemProxies ? "true" : null).add("jvmProxyEnabled", this.jvmProxyEnabled ? "true" : "false").add("proxyHostPort", this.getProxy().orNull()).add("user", this.user).add("type", (Object)(this.host != null ? this.type : null)).toString();
    }
}

