/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import org.apache.pulsar.jcloud.shade.com.google.inject.name.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseTenants;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Identity.class)
@Path(value="/tenants")
public interface TenantApi {
    @Named(value="tenant:list")
    @GET
    @ResponseParser(value=ParseTenants.class)
    @Transform(value=ParseTenants.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Tenant> list();

    @Named(value="tenant:list")
    @GET
    @ResponseParser(value=ParseTenants.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Tenant> list(PaginationOptions var1);

    @Named(value="tenant:get")
    @GET
    @SelectJson(value={"tenant"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Tenant get(@PathParam(value="id") String var1);

    @Named(value="tenant:get")
    @GET
    @SelectJson(value={"tenant"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Tenant getByName(@QueryParam(value="name") String var1);
}

