/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.suppliers;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableListMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.Assisted;
import org.apache.pulsar.jcloud.shade.jakarta.annotation.Resource;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.catalog.functions.ServiceEndpointResolutionStrategy;
import org.jclouds.openstack.keystone.catalog.functions.ServiceEndpointToRegion;

public class LocationIdToURIFromServiceEndpointsForTypeAndVersion
implements Supplier<Map<String, Supplier<URI>>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Supplier<List<ServiceEndpoint>> serviceEndpoints;
    protected final ServiceEndpointResolutionStrategy resolveServiceEndpointURI;
    protected final ServiceEndpointToRegion serviceEndpointToRegion;
    protected final String apiType;
    protected final String apiVersion;
    private final Predicate<ServiceEndpoint> apiVersionEqualsVersionId = new Predicate<ServiceEndpoint>(){

        @Override
        public boolean apply(ServiceEndpoint input) {
            return input.version().equals(LocationIdToURIFromServiceEndpointsForTypeAndVersion.this.apiVersion);
        }
    };
    private final Predicate<ServiceEndpoint> versionAware = new Predicate<ServiceEndpoint>(){

        @Override
        public boolean apply(ServiceEndpoint input) {
            return input.version() != null;
        }
    };
    private final Predicate<ServiceEndpoint> apiTypeEquals = new Predicate<ServiceEndpoint>(){

        @Override
        public boolean apply(ServiceEndpoint input) {
            return input.type().equals(LocationIdToURIFromServiceEndpointsForTypeAndVersion.this.apiType);
        }
    };

    @Inject
    LocationIdToURIFromServiceEndpointsForTypeAndVersion(Supplier<List<ServiceEndpoint>> serviceEndpoints, ServiceEndpointResolutionStrategy resolveServiceEndpointURI, ServiceEndpointToRegion serviceEndpointToRegion, @Assisted(value="apiType") String apiType, @Nullable @Assisted(value="apiVersion") String apiVersion) {
        this.serviceEndpoints = serviceEndpoints;
        this.resolveServiceEndpointURI = resolveServiceEndpointURI;
        this.serviceEndpointToRegion = serviceEndpointToRegion;
        this.apiType = apiType;
        this.apiVersion = apiVersion;
    }

    @Override
    public Map<String, Supplier<URI>> get() {
        List<ServiceEndpoint> endpoints = this.serviceEndpoints.get();
        if (endpoints.isEmpty()) {
            throw new NoSuchElementException("No endpoints were found in the service catalog. Make sure your authentication token has the right scopes and permissions");
        }
        Iterable<ServiceEndpoint> endpointsForType = Iterables.filter(endpoints, this.apiTypeEquals);
        if (Iterables.isEmpty(endpointsForType)) {
            throw new NoSuchElementException(String.format("no endpoints for apiType %s in service endpoints %s", this.apiType, endpoints));
        }
        boolean checkVersionId = this.apiVersion != null && Iterables.any(endpointsForType, this.versionAware);
        Predicate<Object> versionFilter = checkVersionId ? this.apiVersionEqualsVersionId : Predicates.alwaysTrue();
        Iterable<ServiceEndpoint> endpointsForTypeAndVersion = Iterables.filter(endpointsForType, versionFilter);
        if (Iterables.isEmpty(endpointsForTypeAndVersion)) {
            throw new NoSuchElementException(String.format("no service endpoints for apiType %s are of version %s, or version agnostic: %s", this.apiType, this.apiVersion, endpointsForType));
        }
        this.logger.debug("service endpoints for apiType %s and version %s: %s", this.apiType, this.apiVersion, endpointsForTypeAndVersion);
        ImmutableListMultimap<String, ServiceEndpoint> locationToServiceEndpoints = Multimaps.index(endpointsForTypeAndVersion, this.serviceEndpointToRegion);
        return Maps.transformValues(Multimaps.asMap(locationToServiceEndpoints), this.resolveServiceEndpointURI);
    }

    public String toString() {
        return "locationIdToURIFromServiceEndpointsForTypeAndVersion(" + this.apiType + ", " + this.apiVersion + ")";
    }

    public static interface Factory {
        public LocationIdToURIFromServiceEndpointsForTypeAndVersion createForApiTypeAndVersion(@Assisted(value="apiType") String var1, @Nullable @Assisted(value="apiVersion") String var2) throws NoSuchElementException;
    }
}

