/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain.templates;

import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.jclouds.googlecloudstorage.domain.Bucket;
import org.jclouds.googlecloudstorage.domain.BucketAccessControls;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.domain.ObjectAccessControls;
import org.jclouds.googlecloudstorage.domain.Owner;

public class BucketTemplate {
    private String name;
    private Long projectNumber;
    private List<BucketAccessControls> acl = Lists.newArrayList();
    private List<ObjectAccessControls> defaultObjectAccessControls = Lists.newArrayList();
    private Owner owner;
    private DomainResourceReferences.Location location;
    private Bucket.Website website;
    private Bucket.Logging logging;
    private Bucket.Versioning versioning;
    private List<Bucket.Cors> cors = Lists.newArrayList();
    private Bucket.LifeCycle lifeCycle;
    private DomainResourceReferences.StorageClass storageClass;

    public BucketTemplate name(String name) {
        this.name = name;
        return this;
    }

    public BucketTemplate projectNumber(Long projectNumber) {
        this.projectNumber = projectNumber;
        return this;
    }

    public BucketTemplate owner(Owner owner) {
        this.owner = owner;
        return this;
    }

    public BucketTemplate location(DomainResourceReferences.Location location) {
        this.location = location;
        return this;
    }

    public BucketTemplate website(Bucket.Website website) {
        this.website = website;
        return this;
    }

    public BucketTemplate logging(Bucket.Logging logging) {
        this.logging = logging;
        return this;
    }

    public BucketTemplate versioning(Bucket.Versioning versioning) {
        this.versioning = versioning;
        return this;
    }

    public BucketTemplate lifeCycle(Bucket.LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    public BucketTemplate storageClass(DomainResourceReferences.StorageClass storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public BucketTemplate addAcl(BucketAccessControls bucketAccessControls) {
        this.acl.add(bucketAccessControls);
        return this;
    }

    public BucketTemplate acl(List<BucketAccessControls> acl) {
        this.acl.addAll(acl);
        return this;
    }

    public BucketTemplate addDefaultObjectAccessControls(ObjectAccessControls oac) {
        this.defaultObjectAccessControls.add(oac);
        return this;
    }

    public BucketTemplate defaultObjectAccessControls(List<ObjectAccessControls> defaultObjectAcl) {
        this.defaultObjectAccessControls.addAll(defaultObjectAcl);
        return this;
    }

    public BucketTemplate addCORS(Bucket.Cors cors) {
        this.cors.add(cors);
        return this;
    }

    public BucketTemplate cors(List<Bucket.Cors> cors) {
        this.cors.addAll(cors);
        return this;
    }

    public Long projectNumber() {
        return this.projectNumber;
    }

    public String name() {
        return this.name;
    }

    public List<BucketAccessControls> acl() {
        return this.acl;
    }

    public List<ObjectAccessControls> defaultObjectAccessControls() {
        return this.defaultObjectAccessControls;
    }

    public Owner owner() {
        return this.owner;
    }

    public DomainResourceReferences.Location location() {
        return this.location;
    }

    public Bucket.Website website() {
        return this.website;
    }

    public Bucket.Logging logging() {
        return this.logging;
    }

    public Bucket.Versioning versioning() {
        return this.versioning;
    }

    public List<Bucket.Cors> cors() {
        return this.cors;
    }

    public Bucket.LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public DomainResourceReferences.StorageClass storageClass() {
        return this.storageClass;
    }
}

