/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ForwardingObject;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;

public abstract class ForwardingBlobStore
extends ForwardingObject
implements BlobStore {
    private final BlobStore blobStore;

    public ForwardingBlobStore(BlobStore blobStore) {
        this.blobStore = Preconditions.checkNotNull(blobStore);
    }

    @Override
    protected BlobStore delegate() {
        return this.blobStore;
    }

    @Override
    public BlobStoreContext getContext() {
        return this.delegate().getContext();
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.delegate().blobBuilder(name);
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return this.delegate().listAssignableLocations();
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return this.delegate().list();
    }

    @Override
    public boolean containerExists(String container) {
        return this.delegate().containerExists(container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        return this.delegate().createContainerInLocation(location, container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions createContainerOptions) {
        return this.delegate().createContainerInLocation(location, container, createContainerOptions);
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        return this.delegate().getContainerAccess(container);
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess containerAccess) {
        this.delegate().setContainerAccess(container, containerAccess);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container) {
        return this.delegate().list(container);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        return this.delegate().list(container, options);
    }

    @Override
    public void clearContainer(String container) {
        this.delegate().clearContainer(container);
    }

    @Override
    public void clearContainer(String container, ListContainerOptions options) {
        this.delegate().clearContainer(container, options);
    }

    @Override
    public void deleteContainer(String container) {
        this.delegate().deleteContainer(container);
    }

    @Override
    public boolean deleteContainerIfEmpty(String container) {
        return this.delegate().deleteContainerIfEmpty(container);
    }

    @Override
    public boolean directoryExists(String container, String directory) {
        return this.delegate().directoryExists(container, directory);
    }

    @Override
    public void createDirectory(String container, String directory) {
        this.delegate().createDirectory(container, directory);
    }

    @Override
    public void deleteDirectory(String container, String directory) {
        this.delegate().deleteDirectory(container, directory);
    }

    @Override
    public boolean blobExists(String container, String name) {
        return this.delegate().blobExists(container, name);
    }

    @Override
    public String putBlob(String containerName, Blob blob) {
        return this.delegate().putBlob(containerName, blob);
    }

    @Override
    public String putBlob(String containerName, Blob blob, PutOptions putOptions) {
        return this.delegate().putBlob(containerName, blob, putOptions);
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        return this.delegate().copyBlob(fromContainer, fromName, toContainer, toName, options);
    }

    @Override
    public BlobMetadata blobMetadata(String container, String name) {
        return this.delegate().blobMetadata(container, name);
    }

    @Override
    public Blob getBlob(String containerName, String blobName) {
        return this.delegate().getBlob(containerName, blobName);
    }

    @Override
    public Blob getBlob(String containerName, String blobName, GetOptions getOptions) {
        return this.delegate().getBlob(containerName, blobName, getOptions);
    }

    @Override
    public void removeBlob(String container, String name) {
        this.delegate().removeBlob(container, name);
    }

    @Override
    public void removeBlobs(String container, Iterable<String> iterable) {
        this.delegate().removeBlobs(container, iterable);
    }

    @Override
    public BlobAccess getBlobAccess(String container, String name) {
        return this.delegate().getBlobAccess(container, name);
    }

    @Override
    public void setBlobAccess(String container, String name, BlobAccess access) {
        this.delegate().setBlobAccess(container, name, access);
    }

    @Override
    public long countBlobs(String container) {
        return this.delegate().countBlobs(container);
    }

    @Override
    public long countBlobs(String container, ListContainerOptions options) {
        return this.delegate().countBlobs(container, options);
    }

    @Override
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        return this.delegate().initiateMultipartUpload(container, blobMetadata, options);
    }

    @Override
    public void abortMultipartUpload(MultipartUpload mpu) {
        this.delegate().abortMultipartUpload(mpu);
    }

    @Override
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        return this.delegate().completeMultipartUpload(mpu, parts);
    }

    @Override
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        return this.delegate().uploadMultipartPart(mpu, partNumber, payload);
    }

    @Override
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        return this.delegate().listMultipartUpload(mpu);
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String container) {
        return this.delegate().listMultipartUploads(container);
    }

    @Override
    public long getMinimumMultipartPartSize() {
        return this.delegate().getMinimumMultipartPartSize();
    }

    @Override
    public long getMaximumMultipartPartSize() {
        return this.delegate().getMaximumMultipartPartSize();
    }

    @Override
    public int getMaximumNumberOfParts() {
        return this.delegate().getMaximumNumberOfParts();
    }

    @Override
    public void downloadBlob(String container, String name, File destination) {
        this.delegate().downloadBlob(container, name, destination);
    }

    @Override
    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        this.delegate().downloadBlob(container, name, destination, executor);
    }

    @Override
    public InputStream streamBlob(String container, String name) {
        return this.delegate().streamBlob(container, name);
    }

    @Override
    public InputStream streamBlob(String container, String name, ExecutorService executor) {
        return this.delegate().streamBlob(container, name, executor);
    }
}

