/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import java.util.ArrayList;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ListContainerStrategy;

@Singleton
public class ConcatenateContainerLists
implements ListContainerStrategy {
    protected final BlobStore connection;

    @Inject
    public ConcatenateContainerLists(BlobStore connection) {
        this.connection = connection;
    }

    @Override
    public Iterable<? extends StorageMetadata> execute(String container, ListContainerOptions options) {
        try {
            boolean truncated = true;
            ArrayList<PageSet<? extends StorageMetadata>> listings = Lists.newArrayList();
            while (truncated) {
                PageSet<? extends StorageMetadata> listing = this.connection.list(container, options);
                boolean bl = truncated = listing.getNextMarker() != null;
                if (truncated) {
                    options = options instanceof ListContainerOptions.ImmutableListContainerOptions ? options.clone().afterMarker(listing.getNextMarker()) : options.afterMarker(listing.getNextMarker());
                }
                listings.add(listing);
            }
            return Iterables.concat(listings);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e, BlobRuntimeException.class);
            throw new BlobRuntimeException("Error getting resource metadata in container: " + container, e);
        }
    }
}

