/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azureblob.config.InsufficientAccessRightsException;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Throwables2;

@Singleton
public class BlobPropertiesToBlobMetadata
implements Function<BlobProperties, MutableBlobMetadata> {
    private final LoadingCache<String, PublicAccess> containerAcls;

    @Inject
    public BlobPropertiesToBlobMetadata(LoadingCache<String, PublicAccess> containerAcls) {
        this.containerAcls = Preconditions.checkNotNull(containerAcls, "containerAcls");
    }

    @Override
    public MutableBlobMetadata apply(BlobProperties from) {
        MutableBlobMetadataImpl to;
        block7: {
            if (from == null) {
                return null;
            }
            to = new MutableBlobMetadataImpl();
            HttpUtils.copy(from.getContentMetadata(), to.getContentMetadata());
            to.setUserMetadata(from.getMetadata());
            to.setETag(from.getETag());
            to.setLastModified(from.getLastModified());
            to.setName(from.getName());
            to.setContainer(from.getContainer());
            to.setUri(from.getUrl());
            if (from.getContainer() != null) {
                try {
                    PublicAccess containerAcl = this.containerAcls.getUnchecked(from.getContainer());
                    if (containerAcl != PublicAccess.PRIVATE) {
                        to.setPublicUri(from.getUrl());
                    }
                }
                catch (RuntimeException ex) {
                    InsufficientAccessRightsException iare = Throwables2.getFirstThrowableOfType(ex, InsufficientAccessRightsException.class);
                    if (iare != null) break block7;
                    throw ex;
                }
            }
        }
        if (to.getContentMetadata() != null && to.getContentMetadata().getContentType() != null && to.getContentMetadata().getContentType().equals("application/directory")) {
            to.setType(StorageType.FOLDER);
        } else {
            to.setType(StorageType.BLOB);
        }
        to.setSize(from.getContentMetadata().getContentLength());
        AccessTier tier = from.getTier();
        to.setTier((tier != null ? tier : AccessTier.HOT).toTier());
        return to;
    }
}

