/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class InstallationDependency {
    private static final Properties VERSION_PROPERTIES = new Properties();
    private static final String PROPERTIES_FILE = "/versions.properties";
    public static final InstallationDependency PORTLET_API;
    public static final InstallationDependency CDI_IMPL;
    public static final InstallationDependency ANNOTATION_DETECTOR;
    public static final InstallationDependency SLF4J_API;
    public static final InstallationDependency SLF4J_IMPL;
    public static final InstallationDependency CONTAINER_API;
    public static final InstallationDependency CONTAINER;
    public static final InstallationDependency TAGLIB;
    public static final InstallationDependency CONTAINER_DRIVER_API;
    public static final InstallationDependency PORTAL;
    public static final InstallationDependency TESTSUITE;
    public static final InstallationDependency CASTOR;
    public static final InstallationDependency COMMONS_LOGGING_API;
    public static final InstallationDependency XERCES;
    public static final InstallationDependency XML_PARSER_APIS;
    public static final InstallationDependency JAXB_API;
    public static final InstallationDependency JAXB_IMPL;
    public static final InstallationDependency STAX_API;
    public static final InstallationDependency STAX_IMPL;
    public static final InstallationDependency XALAN;
    public static final InstallationDependency ACTIVATION;
    public static final InstallationDependency CCPP_API;
    private static final List<InstallationDependency> ENDORSED;
    private static final List<InstallationDependency> SHARED;
    private String groupId;
    private String artifactId;
    private String version;
    private String type;

    public static Collection<InstallationDependency> getEndorsedDependencies() {
        return Collections.unmodifiableCollection(ENDORSED);
    }

    public static Collection<InstallationDependency> getSharedDependencies() {
        return Collections.unmodifiableCollection(SHARED);
    }

    public InstallationDependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "jar");
    }

    public InstallationDependency(String groupId, String artifactId, String version, String type) {
        if (version == null || version.trim().equalsIgnoreCase("")) {
            throw new RuntimeException("Missing or invalid property for artifact " + artifactId + " in " + PROPERTIES_FILE + "!");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    static {
        try {
            VERSION_PROPERTIES.load(InstallationDependency.class.getResourceAsStream(PROPERTIES_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load /versions.properties from the classpath!", e);
        }
        PORTLET_API = new InstallationDependency("javax.portlet", "portlet-api", VERSION_PROPERTIES.getProperty("portals.portlet-api.version"));
        CDI_IMPL = new InstallationDependency("org.jboss.weld.servlet", "weld-servlet", VERSION_PROPERTIES.getProperty("cdi.version"));
        ANNOTATION_DETECTOR = new InstallationDependency("eu.infomas", "annotation-detector", VERSION_PROPERTIES.getProperty("annotation-detector.version"));
        SLF4J_API = new InstallationDependency("org.slf4j", "slf4j-api", VERSION_PROPERTIES.getProperty("slf4j.version"));
        SLF4J_IMPL = new InstallationDependency("org.slf4j", "slf4j-jdk14", VERSION_PROPERTIES.getProperty("slf4j.version"));
        CONTAINER_API = new InstallationDependency("org.apache.portals.pluto", "pluto-container-api", VERSION_PROPERTIES.getProperty("pluto.version"));
        CONTAINER = new InstallationDependency("org.apache.portals.pluto", "pluto-container", VERSION_PROPERTIES.getProperty("pluto.version"));
        TAGLIB = new InstallationDependency("org.apache.portals.pluto", "pluto-taglib", VERSION_PROPERTIES.getProperty("pluto.version"));
        CONTAINER_DRIVER_API = new InstallationDependency("org.apache.portals.pluto", "pluto-container-driver-api", VERSION_PROPERTIES.getProperty("pluto.version"));
        PORTAL = new InstallationDependency("org.apache.portals.pluto", "pluto-portal", VERSION_PROPERTIES.getProperty("pluto.version"), "war");
        TESTSUITE = new InstallationDependency("org.apache.portals.pluto", "pluto-testsuite", VERSION_PROPERTIES.getProperty("pluto.version"), "war");
        CASTOR = new InstallationDependency("org.codehaus.castor", "castor", VERSION_PROPERTIES.getProperty("castor.version"));
        COMMONS_LOGGING_API = new InstallationDependency("commons-logging", "commons-logging-api", VERSION_PROPERTIES.getProperty("commons-logging.version"));
        XERCES = new InstallationDependency("xerces", "xercesImpl", VERSION_PROPERTIES.getProperty("xercesImpl.version"));
        XML_PARSER_APIS = new InstallationDependency("xerces", "xmlParserAPIs", VERSION_PROPERTIES.getProperty("xmlParserAPIs.version"));
        JAXB_API = new InstallationDependency("javax.xml.bind", "jaxb-api", VERSION_PROPERTIES.getProperty("jaxb.version"));
        JAXB_IMPL = new InstallationDependency("com.sun.xml.bind", "jaxb-impl", VERSION_PROPERTIES.getProperty("jaxb-impl.version"));
        STAX_API = new InstallationDependency("stax", "stax-api", VERSION_PROPERTIES.getProperty("stax.api.version"));
        STAX_IMPL = new InstallationDependency("stax", "stax", VERSION_PROPERTIES.getProperty("stax.impl.version"));
        XALAN = new InstallationDependency("xalan", "xalan", VERSION_PROPERTIES.getProperty("xalan.version"));
        ACTIVATION = new InstallationDependency("javax.activation", "activation", VERSION_PROPERTIES.getProperty("activation.version"));
        CCPP_API = new InstallationDependency("javax.ccpp", "ccpp", VERSION_PROPERTIES.getProperty("ccpp-api.version"));
        ENDORSED = new ArrayList<InstallationDependency>();
        SHARED = new ArrayList<InstallationDependency>();
        SHARED.add(PORTLET_API);
        SHARED.add(CONTAINER);
        SHARED.add(CONTAINER_API);
        SHARED.add(CONTAINER_DRIVER_API);
        SHARED.add(TAGLIB);
        SHARED.add(CCPP_API);
        SHARED.add(CDI_IMPL);
        SHARED.add(ANNOTATION_DETECTOR);
        SHARED.add(SLF4J_API);
        SHARED.add(SLF4J_IMPL);
    }
}

