/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.pluto.container.bean.processor.PortletSessionScopedBeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectScopedBeanHolder
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectScopedBeanHolder.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final long serialVersionUID = 3856727894564632122L;
    private static final String ATTRIBNAME = "redirectScopedBeanHolder";
    private static final ThreadLocal<RedirectScopedBeanHolder> holders = new ThreadLocal();
    private final PortletSessionScopedBeanMap beans;
    private final String windowId;

    private RedirectScopedBeanHolder(PortletSessionScopedBeanMap beans, String windowId) {
        this.beans = beans;
        this.windowId = windowId;
    }

    public static void setBeanHolder(PortletRequest req) {
        PortletSession ps = req.getPortletSession();
        String windowId = req.getWindowID();
        PortletSessionScopedBeanMap map = (PortletSessionScopedBeanMap)ps.getAttribute(ATTRIBNAME, 1);
        boolean createdMap = false;
        if (map == null) {
            map = new PortletSessionScopedBeanMap();
            ps.setAttribute(ATTRIBNAME, (Object)map, 1);
            createdMap = true;
        }
        RedirectScopedBeanHolder holder = new RedirectScopedBeanHolder(map, windowId);
        holders.set(holder);
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Set redirect scope bean holder.");
            txt.append(" ThreadId: ").append(Thread.currentThread().getId());
            txt.append(", PortletSession: ").append(ps.getId());
            txt.append(", WindowId: ").append(windowId);
            txt.append(", Added new BeanMap to session: ").append(createdMap);
            LOG.debug(txt.toString());
        }
    }

    public static void removeBeanHolder(boolean destroyBeans) {
        if (destroyBeans) {
            RedirectScopedBeanHolder holder = holders.get();
            holder.removeBeans();
        }
        holders.remove();
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removed redirect scope bean holder.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            LOG.debug(txt.toString());
        }
    }

    public static RedirectScopedBeanHolder getBeanHolder() {
        return holders.get();
    }

    public static RedirectScopedBeanHolder deregister() {
        RedirectScopedBeanHolder holder = holders.get();
        holders.remove();
        return holder;
    }

    public static void register(RedirectScopedBeanHolder holder) {
        holders.set(holder);
    }

    public <T> T getBean(Contextual<T> bean) {
        return this.beans.getBeanInstance(this.windowId, bean);
    }

    public <T> void putBeanInstance(Contextual<T> bean, CreationalContext<T> crco, T instance) {
        this.beans.putBeanInstance(this.windowId, bean, crco, instance);
    }

    private void removeBeans() {
        this.beans.removeByWindowId(this.windowId);
    }
}

