/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;

public class EventDefinitionImpl
implements EventDefinition {
    private QName qn;
    private final ArrayList<QName> aliases = new ArrayList();
    private final List<Description> descs = new ArrayList<Description>();
    private final List<DisplayName> dispNames = new ArrayList<DisplayName>();
    private String valType;

    public EventDefinitionImpl(EventDefinition edi) {
        this.qn = new QName(edi.getQName().getNamespaceURI(), edi.getQName().getLocalPart());
        this.valType = edi.getValueType();
        for (QName qn : edi.getAliases()) {
            this.aliases.add(new QName(qn.getNamespaceURI(), qn.getLocalPart()));
        }
        for (Description desc : edi.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
        for (DisplayName disp : edi.getDisplayNames()) {
            this.dispNames.add(new DisplayNameImpl(disp));
        }
    }

    public EventDefinitionImpl(QName qn) {
        this.qn = qn;
    }

    @Override
    public QName getQName() {
        return this.qn;
    }

    @Override
    public void setQName(QName qn) {
        this.qn = qn;
    }

    @Override
    public List<QName> getAliases() {
        return new ArrayList<QName>(this.aliases);
    }

    @Override
    public void addAlias(QName qName) {
        this.aliases.add(qName);
    }

    @Override
    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    @Override
    public DisplayName getDisplayName(Locale locale) {
        DisplayNameImpl ret = null;
        for (DisplayName item : this.dispNames) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DisplayNameImpl(item);
        }
        return ret;
    }

    @Override
    public List<DisplayName> getDisplayNames() {
        return new ArrayList<DisplayName>(this.dispNames);
    }

    @Override
    public void addDisplayName(DisplayName desc) {
        this.dispNames.add(desc);
    }

    @Override
    public String getValueType() {
        return this.valType;
    }

    @Override
    public void setValueType(String valueType) {
        this.valType = valueType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qn == null ? 0 : this.qn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventDefinitionImpl other = (EventDefinitionImpl)obj;
        return !(this.qn == null ? other.qn != null : !this.qn.equals(other.qn));
    }
}

