/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletPreference;
import org.apache.pluto.container.PortletPreferencesService;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletPreferenceImpl;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.util.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletPreferencesImpl
implements PortletPreferences {
    private static final Logger LOG = LoggerFactory.getLogger(PortletPreferencesImpl.class);
    private static final StringManager EXCEPTIONS = StringManager.getManager(PortletPreferencesImpl.class.getPackage().getName());
    private PortletPreferencesService preferencesService;
    private PortletWindow window;
    private PortletRequest request;
    private Map<String, PortletPreference> defaultPreferences;
    private final Map<String, PortletPreference> preferences = new HashMap<String, PortletPreference>();

    public PortletPreferencesImpl(PortletContainer container, PortletWindow window, PortletRequest request) {
        this.window = window;
        this.request = request;
        this.preferencesService = container.getContainerServices().getPortletPreferencesService();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using PortletPreferencesService: " + this.preferencesService.getClass().getName());
        }
        try {
            this.defaultPreferences = this.preferencesService.getDefaultPreferences(window, request);
            if (this.defaultPreferences != null) {
                for (PortletPreference p : this.defaultPreferences.values()) {
                    this.preferences.put(p.getName(), p.clone());
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loaded default preferences: " + this.toString());
            }
            Map<String, PortletPreference> storedPreferences = this.preferencesService.getStoredPreferences(window, request);
            this.preferences.putAll(storedPreferences);
        }
        catch (PortletContainerException ex) {
            LOG.error("Error retrieving preferences.", (Throwable)ex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Merged stored preferences: " + this.toString());
        }
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException(EXCEPTIONS.getString("error.null", "Preference key "));
        }
        PortletPreference pref = this.preferences.get(key);
        return pref != null && pref.isReadOnly();
    }

    public String getValue(String key, String defaultValue) {
        String[] values = this.getValues(key, new String[]{defaultValue});
        String value = defaultValue;
        if (values != null) {
            if (values.length == 0) {
                value = null;
            } else if (values[0] != null) {
                value = values[0];
            }
        }
        return value;
    }

    public String[] getValues(String key, String[] defaultValues) {
        if (key == null) {
            throw new IllegalArgumentException(EXCEPTIONS.getString("error.null", "Preference key "));
        }
        String[] values = null;
        PortletPreference pref = this.preferences.get(key);
        if (pref != null) {
            values = pref.getValues();
        }
        if (values == null) {
            values = defaultValues;
        }
        return values;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        String[] stringArray;
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(EXCEPTIONS.getString("error.preference.readonly", key));
        }
        PortletPreference pref = this.preferences.get(key);
        if (value == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        String[] values = stringArray;
        if (pref != null) {
            pref.setValues(values);
        } else {
            pref = new PortletPreferenceImpl(key, values);
            this.preferences.put(key, pref);
        }
    }

    public void setValues(String key, String ... values) throws ReadOnlyException {
        PortletPreference pref;
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(EXCEPTIONS.getString("error.preference.readonly", key));
        }
        if (values == null) {
            values = new String[]{};
        }
        if ((pref = this.preferences.get(key)) != null) {
            pref.setValues(values);
        } else {
            pref = new PortletPreferenceImpl(key, values);
            this.preferences.put(key, pref);
        }
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.preferences.keySet());
    }

    public Map<String, String[]> getMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (PortletPreference pref : this.preferences.values()) {
            map.put(pref.getName(), pref.getValues() != null ? (String[])pref.getValues().clone() : null);
        }
        return Collections.unmodifiableMap(map);
    }

    public void reset(String key) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(EXCEPTIONS.getString("error.preference.readonly", key));
        }
        PortletPreference p = this.defaultPreferences.get(key);
        if (p != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resetting preference for key: " + key);
            }
            this.preferences.put(key, p.clone());
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resetting preference to null for key: " + key);
            }
            this.preferences.remove(key);
        }
    }

    public void store() throws IOException, ValidatorException {
        if ("RENDER_PHASE".equals(this.request.getAttribute("javax.portlet.lifecycle_phase"))) {
            throw new IllegalStateException("store is not allowed during RENDER phase.");
        }
        this.internalStore();
    }

    protected final void internalStore() throws IOException, ValidatorException {
        PortletDefinition portletD = this.window.getPortletDefinition();
        PreferencesValidator validator = this.preferencesService.getPreferencesValidator(portletD);
        if (validator != null) {
            validator.validate((PortletPreferences)this);
        }
        try {
            this.preferencesService.store(this.window, this.request, this.preferences);
        }
        catch (PortletContainerException ex) {
            LOG.error("Error storing preferences.", (Throwable)ex);
            throw new IOException("Error storing perferences: " + ex.getMessage());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("[");
        for (PortletPreference p : this.preferences.values()) {
            buffer.append(p.getName());
            buffer.append("(readOnly:").append(p.isReadOnly()).append(")=");
            String[] values = p.getValues();
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    buffer.append(values[i]);
                    if (i >= values.length - 1) continue;
                    buffer.append(",");
                }
            } else {
                buffer.append("NULL");
            }
            buffer.append(";");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

