/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.MutablePortletParameters;
import javax.portlet.PortletParameters;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.MutablePortletParametersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortletParametersImpl
implements PortletParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortletParametersImpl.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();
    protected final PortletURLProvider urlProvider;
    protected final String windowId;
    protected final PortletURLProvider.ParamType type;
    protected final Map<String, String[]> params;

    protected PortletParametersImpl(PortletURLProvider urlProvider, String windowId, PortletURLProvider.ParamType type) {
        this.urlProvider = urlProvider;
        this.windowId = windowId;
        this.type = type;
        this.params = this.urlProvider.getParameterMap(windowId, type);
        if (isTrace) {
            LOGGER.debug("Created PortletParameters object for window: " + windowId + ", Type: " + (Object)((Object)type));
        }
    }

    protected PortletParametersImpl(Map<String, String[]> params, String windowId, PortletURLProvider.ParamType type) {
        this.urlProvider = null;
        this.type = type;
        this.windowId = windowId;
        this.params = new HashMap<String, String[]>();
        for (String name : params.keySet()) {
            this.params.put(name, (String[])params.get(name).clone());
        }
    }

    protected void checkNull(String msg, Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Argument " + msg + " cannot be null.");
        }
    }

    public String getValue(String name) {
        String val;
        this.checkNull("name", name);
        String[] vals = this.params.get(name);
        String string = val = vals == null || vals.length == 0 ? null : vals[0];
        if (isTrace) {
            LOGGER.debug("Name: " + name + ", Value: " + val);
        }
        return val;
    }

    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : this.params.keySet()) {
            names.add(name);
        }
        if (isTrace) {
            LOGGER.debug("Parameter Names: " + names.toString());
        }
        return names;
    }

    public String[] getValues(String name) {
        Object[] vals;
        this.checkNull("name", name);
        Object[] objectArray = vals = this.params.get(name) == null ? null : (String[])this.params.get(name).clone();
        if (isTrace) {
            LOGGER.debug("Name: " + name + ", Values: " + Arrays.toString(vals));
        }
        return vals;
    }

    public boolean isEmpty() {
        boolean e = this.params.isEmpty();
        if (isTrace) {
            LOGGER.debug("Parameters is empty: " + e);
        }
        return e;
    }

    public int size() {
        return this.params.size();
    }

    public MutablePortletParameters clone() {
        if (isTrace) {
            LOGGER.debug("Window ID: " + this.windowId + ", ParameterType: " + (Object)((Object)this.type));
        }
        MutablePortletParametersImpl mpp = new MutablePortletParametersImpl(this.params, this.windowId, this.type);
        return mpp;
    }
}

