/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.InvalidAnnotationException;
import org.apache.pluto.container.bean.processor.MethodDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationRecognizer {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationRecognizer.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    protected final Set<Class<? extends Annotation>> classAnnotations;
    protected final Map<Class<? extends Annotation>, List<MethodDescription>> descriptions;
    protected final ConfigSummary summary;

    protected AnnotationRecognizer(Set<Class<? extends Annotation>> cla, Map<Class<? extends Annotation>, List<MethodDescription>> descriptions, ConfigSummary summary) {
        this.classAnnotations = cla;
        this.descriptions = descriptions;
        this.summary = summary;
    }

    private Class<? extends Annotation> setContains(Set<Class<? extends Annotation>> clsSet, Annotation anno) {
        for (Class<? extends Annotation> cls : clsSet) {
            if (!anno.annotationType().isAssignableFrom(cls)) continue;
            return cls;
        }
        return null;
    }

    public void checkAnnotatedType(ProcessAnnotatedType pat) throws InvalidAnnotationException {
        AnnotatedType aType = pat.getAnnotatedType();
        try {
            Set annos = aType.getAnnotations();
            for (Annotation anno : annos) {
                AnnotatedType<?> ret;
                if (this.setContains(this.classAnnotations, anno) == null) continue;
                if (isDebug) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Found Annotation: ").append(anno.toString());
                    txt.append(", portlet name: ").append(this.getDisplayNames(anno));
                    LOG.debug(txt.toString());
                }
                if ((ret = this.handleClassAnnotation(anno, aType)) == null) continue;
                pat.setAnnotatedType(ret);
            }
        }
        catch (Exception e) {
            StringBuilder txt = new StringBuilder("Error processing annotations for ");
            txt.append(aType.toString());
            throw new InvalidAnnotationException(txt.toString(), e);
        }
    }

    protected void checkForMethodAnnotations(Class<?> aClass) {
        String typeName = aClass.getCanonicalName();
        for (Method meth : aClass.getMethods()) {
            for (Annotation anno : meth.getAnnotations()) {
                StringBuilder txt;
                Class<? extends Annotation> keyAnno = this.setContains(this.descriptions.keySet(), anno);
                if (keyAnno == null) continue;
                List<MethodDescription> descs = this.descriptions.get(keyAnno);
                assert (descs != null);
                assert (descs.size() > 0);
                MethodDescription matchingDesc = null;
                StringBuilder errtxt = new StringBuilder(128);
                String sep = "   ";
                for (MethodDescription desc : descs) {
                    if (desc.isMethodMatched(meth)) {
                        matchingDesc = desc;
                        break;
                    }
                    errtxt.append(sep).append(desc.getExpectedSignature(true));
                    sep = "\n   ";
                }
                if (isTrace) {
                    txt = new StringBuilder(128);
                    txt.append("For method annotation: ").append(anno.annotationType().getSimpleName());
                    txt.append(" on class: ").append(typeName);
                    txt.append(", method: ").append(meth.getName());
                    if (matchingDesc != null) {
                        txt.append(", recognized type: ").append((Object)matchingDesc.getType());
                        txt.append(", signature variant: ").append((Object)matchingDesc.getVariant());
                    } else {
                        txt.append(", No match found. Error string:\n");
                        txt.append((CharSequence)errtxt);
                    }
                    LOG.trace(txt.toString());
                }
                if (matchingDesc != null) {
                    this.handleMethod(anno, aClass, meth, matchingDesc);
                    continue;
                }
                txt = new StringBuilder(128);
                txt.append("Unrecognized method annotation: ").append(anno.annotationType().getSimpleName());
                txt.append(", Class: ").append(typeName);
                txt.append(", Method: ").append(meth.getName());
                txt.append("\n").append((CharSequence)errtxt);
                LOG.debug(txt.toString());
                for (String n : this.getDisplayNames(anno)) {
                    this.summary.addErrorString(n, txt.toString());
                }
            }
        }
    }

    protected String[] getDisplayNames(Annotation anno) {
        String[] portletNames = new String[]{"unknown"};
        try {
            Method getPN = anno.getClass().getMethod("portletName", new Class[0]);
            String[] annoNames = new String[]{(String)getPN.invoke((Object)anno, new Object[0])};
            if (annoNames[0] != null && annoNames[0].length() > 0) {
                portletNames = annoNames;
            }
        }
        catch (Exception e) {
            try {
                Method getPN = anno.getClass().getMethod("portletNames", new Class[0]);
                String[] names = (String[])getPN.invoke((Object)anno, new Object[0]);
                if (names != null && names.length > 0) {
                    portletNames = names;
                }
            }
            catch (Exception e2) {
                try {
                    Method getPN = anno.getClass().getMethod("value", new Class[0]);
                    String[] annoNames = new String[]{(String)getPN.invoke((Object)anno, new Object[0])};
                    if (annoNames[0] != null && annoNames[0].length() > 0) {
                        portletNames = annoNames;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return portletNames;
    }

    protected abstract AnnotatedType<?> handleClassAnnotation(Annotation var1, AnnotatedType<?> var2) throws InvalidAnnotationException;

    protected abstract void handleMethod(Annotation var1, Class<?> var2, Method var3, MethodDescription var4);

    protected abstract void activateCustomScopes(BeanManager var1);
}

