/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.impl.PreferenceImpl;

public class PreferencesImpl
implements Preferences {
    private final Map<String, Preference> prefs = new HashMap<String, Preference>();
    private String prefVal;
    private boolean isNullValidator = false;

    public PreferencesImpl() {
    }

    public PreferencesImpl(Preferences pr) {
        for (Preference pref : pr.getPortletPreferences()) {
            this.prefs.put(pref.getName(), new PreferenceImpl(pref));
        }
        this.prefVal = pr.getPreferencesValidator();
        this.isNullValidator = pr.isNullValidator();
    }

    @Override
    public Preference getPortletPreference(String name) {
        PreferenceImpl pref = this.prefs.get(name) == null ? null : new PreferenceImpl(this.prefs.get(name));
        return pref;
    }

    @Override
    public List<Preference> getPortletPreferences() {
        ArrayList<Preference> rPrefs = new ArrayList<Preference>();
        for (Preference pref : this.prefs.values()) {
            rPrefs.add(new PreferenceImpl(pref));
        }
        return rPrefs;
    }

    @Override
    public void addPreference(Preference pref) {
        this.prefs.put(pref.getName(), new PreferenceImpl(pref));
    }

    @Override
    public String getPreferencesValidator() {
        return this.prefVal;
    }

    @Override
    public void setPreferencesValidator(String preferencesValidator) {
        this.prefVal = preferencesValidator;
    }

    @Override
    public boolean isNullValidator() {
        return this.isNullValidator;
    }

    @Override
    public void setNullValidator(boolean isNullValidator) {
        this.isNullValidator = isNullValidator;
    }
}

