/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.portlet.ActionParameters;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.MimeResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceParameters;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.annotations.ContextPath;
import javax.portlet.annotations.Namespace;
import javax.portlet.annotations.PortletName;
import javax.portlet.annotations.PortletRequestScoped;
import javax.portlet.annotations.WindowId;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletArtifactProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PortletArtifactProducer.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final ThreadLocal<PortletArtifactProducer> producers = new ThreadLocal();
    private PortletRequest req;
    private PortletResponse resp;
    private PortletConfig config;

    private PortletArtifactProducer() {
    }

    @Produces
    public static PortletArtifactProducer getPAP() {
        PortletArtifactProducer pap = producers.get();
        if (pap == null) {
            pap = new PortletArtifactProducer();
            producers.set(pap);
            if (isTrace) {
                StringBuilder txt = new StringBuilder(80);
                txt.append("Created new empty PortletArtifactProducer");
                txt.append(", ThreadId=").append(Thread.currentThread().getId());
                LOG.trace(txt.toString());
            }
        }
        return producers.get();
    }

    public static void remove() {
        producers.remove();
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Disposed of the PortletArtifactProducer");
            txt.append(", ThreadId=").append(Thread.currentThread().getId());
            LOG.trace(txt.toString());
        }
    }

    public static void setPrecursors(PortletRequest req, PortletResponse resp, PortletConfig config) {
        PortletArtifactProducer pap = PortletArtifactProducer.getPAP();
        pap.req = req;
        pap.resp = resp;
        pap.config = config;
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Set precursors.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            txt.append(", Portlet name: ").append(config == null ? "null" : config.getPortletName());
            LOG.trace(txt.toString());
        }
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletConfig")
    public static PortletConfig producePortletConfig() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            txt.append(", Portlet name: ").append(pap.config.getPortletName());
            txt.append(", Init param names: ").append(Collections.list(pap.config.getInitParameterNames()).toString());
            LOG.trace(txt.toString());
        }
        return pap.config;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletContext")
    public static PortletContext producePortletContext() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.config.getPortletContext();
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletRequest")
    public static PortletRequest producePortletRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletResponse")
    public static PortletResponse producePortletResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="clientDataRequest")
    @Typed(value={ClientDataRequest.class})
    public static ClientDataRequest produceClientDataRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ClientDataRequest req = null;
        if (pap.req instanceof ClientDataRequest) {
            req = (ClientDataRequest)pap.req;
        }
        return req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="mimeResponse")
    @Typed(value={MimeResponse.class})
    public static MimeResponse produceMimeResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        MimeResponse resp = null;
        if (pap.resp instanceof MimeResponse) {
            resp = (MimeResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="stateAwareResponse")
    @Typed(value={StateAwareResponse.class})
    public static StateAwareResponse produceStateAwareResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        StateAwareResponse resp = null;
        if (pap.resp instanceof StateAwareResponse) {
            resp = (StateAwareResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="actionRequest")
    @Typed(value={ActionRequest.class})
    public static ActionRequest produceActionRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ActionRequest req = null;
        if (pap.req instanceof ActionRequest) {
            req = (ActionRequest)pap.req;
        }
        return req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="actionResponse")
    @Typed(value={ActionResponse.class})
    public static ActionResponse produceActionResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ActionResponse resp = null;
        if (pap.resp instanceof ActionResponse) {
            resp = (ActionResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="headerRequest")
    @Typed(value={HeaderRequest.class})
    public static HeaderRequest produceHeaderRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        HeaderRequest req = null;
        if (pap.req instanceof HeaderRequest) {
            req = (HeaderRequest)pap.req;
        }
        return req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="headerResponse")
    @Typed(value={HeaderResponse.class})
    public static HeaderResponse produceHeaderResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        HeaderResponse resp = null;
        if (pap.resp instanceof HeaderResponse) {
            resp = (HeaderResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="renderRequest")
    @Typed(value={RenderRequest.class})
    public static RenderRequest produceRenderRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        RenderRequest req = null;
        if (pap.req instanceof RenderRequest && !(pap.req instanceof HeaderRequest)) {
            req = (RenderRequest)pap.req;
        }
        return req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="renderResponse")
    @Typed(value={RenderResponse.class})
    public static RenderResponse produceRenderResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        RenderResponse resp = null;
        if (pap.resp instanceof RenderResponse) {
            resp = (RenderResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="eventRequest")
    @Typed(value={EventRequest.class})
    public static EventRequest produceEventRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        EventRequest req = null;
        if (pap.req instanceof EventRequest) {
            req = (EventRequest)pap.req;
        }
        return req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="eventResponse")
    @Typed(value={EventResponse.class})
    public static EventResponse produceEventResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        EventResponse resp = null;
        if (pap.resp instanceof EventResponse) {
            resp = (EventResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="resourceRequest")
    @Typed(value={ResourceRequest.class})
    public static ResourceRequest produceResourceRequest() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ResourceRequest req = null;
        if (pap.req instanceof ResourceRequest) {
            req = (ResourceRequest)pap.req;
        }
        return req;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="resourceResponse")
    @Typed(value={ResourceResponse.class})
    public static ResourceResponse produceResourceResponse() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ResourceResponse resp = null;
        if (pap.resp instanceof ResourceResponse) {
            resp = (ResourceResponse)pap.resp;
        }
        return resp;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletMode")
    public static PortletMode producePortletMode() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getPortletMode();
    }

    @Produces
    @PortletRequestScoped
    @Named(value="windowState")
    public static WindowState produceWindowState() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getWindowState();
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletPreferences")
    public static PortletPreferences producePortletPreferences() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getPreferences();
    }

    @Produces
    @PortletRequestScoped
    @Named(value="cookies")
    public static List<Cookie> produceCookies() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return Arrays.asList(pap.req.getCookies());
    }

    @Produces
    @PortletRequestScoped
    @Named(value="portletSession")
    public static PortletSession producePortletSession() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getPortletSession();
    }

    @Produces
    @PortletRequestScoped
    @Named(value="locales")
    public static List<Locale> produceLocales() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return Collections.list(pap.req.getLocales());
    }

    @Produces
    @PortletRequestScoped
    @Named(value="renderParams")
    @Typed(value={RenderParameters.class})
    public static RenderParameters getRenderParameters() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getRenderParameters();
    }

    @Produces
    @PortletRequestScoped
    @Named(value="mutableRenderParams")
    @Typed(value={MutableRenderParameters.class})
    public static MutableRenderParameters getMutableRenderParameters() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        MutableRenderParameters obj = null;
        if (pap.resp instanceof StateAwareResponse) {
            obj = ((StateAwareResponse)pap.resp).getRenderParameters();
        }
        return obj;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="actionParams")
    @Typed(value={ActionParameters.class})
    public static ActionParameters getActionParameters() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ActionParameters obj = null;
        if (pap.req instanceof ActionRequest) {
            obj = ((ActionRequest)pap.req).getActionParameters();
        }
        return obj;
    }

    @Produces
    @PortletRequestScoped
    @Named(value="resourceParams")
    @Typed(value={ResourceParameters.class})
    public static ResourceParameters getResourceParameters() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        ResourceParameters obj = null;
        if (pap.req instanceof ResourceRequest) {
            obj = ((ResourceRequest)pap.req).getResourceParameters();
        }
        return obj;
    }

    @Produces
    @WindowId
    @Named(value="windowId")
    public static String produceWindowID() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getWindowID();
    }

    @Produces
    @Namespace
    @Named(value="namespace")
    public static String produceNamespace() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.resp.getNamespace();
    }

    @Produces
    @PortletName
    @Named(value="portletName")
    public static String producePortletName() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.config.getPortletName();
    }

    @Produces
    @ContextPath
    @Named(value="contextPath")
    public static String produceContextPath() {
        PortletArtifactProducer pap = producers.get();
        assert (pap != null);
        return pap.req.getContextPath();
    }
}

