/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pluto.container.bean.processor.PortletRequestScopedAnnotatedType;
import org.apache.pluto.container.bean.processor.PortletSessionScopedAnnotatedType;

public class ConfigSummary {
    List<PortletSessionScopedAnnotatedType> appScopedTypes = new ArrayList<PortletSessionScopedAnnotatedType>();
    List<PortletRequestScopedAnnotatedType> reqScopedTypes = new ArrayList<PortletRequestScopedAnnotatedType>();
    private final Map<Class<?>, String> badSessionBeans = new HashMap();
    private final Map<Class<?>, String> badStateBeans = new HashMap();
    private final Map<String, List<String>> errors = new TreeMap<String, List<String>>();

    public void addErrorString(String portletName, String msg) {
        assert (portletName != null && portletName.length() > 0);
        if (!this.errors.containsKey(portletName)) {
            this.errors.put(portletName, new ArrayList());
        }
        this.errors.get(portletName).add(msg);
    }

    public List<String> getErrorStrings(String portletName) {
        assert (portletName != null && portletName.length() > 0);
        ArrayList<String> errs = new ArrayList<String>();
        List<String> perrs = this.errors.get(portletName);
        if (perrs != null) {
            errs.addAll(perrs);
        }
        return errs;
    }

    public List<String> getPortletsWithErrors() {
        return new ArrayList<String>(this.errors.keySet());
    }

    public void addStateBeanErrorString(Class<?> cls, String msg) {
        this.badStateBeans.put(cls, msg);
    }

    public String getStateBeanErrorString(Class<?> bean) {
        return this.badStateBeans.get(bean);
    }

    public List<Class<?>> getStateBeansWithErrors() {
        return new ArrayList(this.badStateBeans.keySet());
    }

    public void addSessionBeanErrorString(Class<?> cls, String msg) {
        this.badSessionBeans.put(cls, msg);
    }

    public String getSessionBeanErrorString(Class<?> bean) {
        return this.badSessionBeans.get(bean);
    }

    public List<Class<?>> getSessionBeansWithErrors() {
        return new ArrayList(this.badSessionBeans.keySet());
    }

    public void addAppScopedType(PortletSessionScopedAnnotatedType type) {
        this.appScopedTypes.add(type);
    }

    public List<PortletSessionScopedAnnotatedType> getAppScopedTypes() {
        return this.appScopedTypes;
    }

    public List<PortletRequestScopedAnnotatedType> getReqScopedTypes() {
        return this.reqScopedTypes;
    }

    public void addReqScopedType(PortletRequestScopedAnnotatedType type) {
        this.reqScopedTypes.add(type);
    }
}

