/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.Enumeration;
import java.util.Map;
import javax.portlet.CacheControl;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletMode;
import javax.portlet.ResourceParameters;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.DispatcherType;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.impl.ClientDataRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRequestImpl
extends ClientDataRequestImpl
implements ResourceRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRequestImpl.class);
    private CacheControl cacheControl;

    public ResourceRequestImpl(PortletResourceRequestContext requestContext, PortletResourceResponseContext responseContext) {
        super(requestContext, responseContext, "RESOURCE_PHASE");
        this.cacheControl = responseContext.getCacheControl();
    }

    @Override
    protected PortletResourceRequestContext getRequestContext() {
        return (PortletResourceRequestContext)this.requestContext;
    }

    protected PortletResourceResponseContext getResponseContext() {
        return (PortletResourceResponseContext)this.responseContext;
    }

    @Override
    public String getProperty(String name) {
        String result = this.getMimeRequestProperty(name, this.cacheControl);
        return result != null ? result : super.getProperty(name);
    }

    public String getCacheability() {
        return this.getRequestContext().getCacheability();
    }

    public String getETag() {
        return this.cacheControl.getETag();
    }

    public Map<String, String[]> getPrivateRenderParameterMap() {
        return ResourceRequestImpl.cloneParameterMap(this.getRequestContext().getPrivateRenderParameterMap());
    }

    public String getResourceID() {
        return this.getRequestContext().getResourceID();
    }

    @Override
    public String getResponseContentType() {
        return this.getServletRequest().getHeader("accept");
    }

    @Override
    public Enumeration<String> getResponseContentTypes() {
        return this.getServletRequest().getHeaders("accept");
    }

    @Override
    public String getParameter(String name) {
        String val = super.getParameter(name);
        if (LOG.isTraceEnabled()) {
            Map<String, String[]> pmap = super.getParameterMap();
            StringBuffer txt = new StringBuffer(1024);
            txt.append("Resource Request parameter map dump:");
            for (String n : pmap.keySet()) {
                txt.append("\nName: " + n + ", Values: ");
                String[] vals = pmap.get(n);
                String sep = "";
                for (String v : vals) {
                    txt.append(sep + v);
                    sep = ", ";
                }
            }
            LOG.debug(txt.toString());
        }
        return val;
    }

    public ResourceParameters getResourceParameters() {
        return this.getRequestContext().getResourceParameters();
    }

    public PortletAsyncContext startPortletAsync() throws IllegalStateException {
        return (PortletAsyncContext)this.getRequestContext().startAsync(this);
    }

    public PortletAsyncContext startPortletAsync(ResourceRequest request, ResourceResponse response) throws IllegalStateException {
        boolean orr = request == this && response == this.getRequestContext().getResponse();
        return (PortletAsyncContext)this.getRequestContext().startAsync(request, response, orr);
    }

    public boolean isAsyncStarted() {
        return this.getRequestContext().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.getRequestContext().isAsyncSupported();
    }

    public PortletAsyncContext getPortletAsyncContext() {
        return (PortletAsyncContext)this.getRequestContext().getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.getRequestContext().getDispatcherType();
    }

    @Override
    public PortletMode getPortletMode() {
        if ("cacheLevelFull".equals(this.getCacheability())) {
            return PortletMode.UNDEFINED;
        }
        return super.getPortletMode();
    }

    @Override
    public WindowState getWindowState() {
        if ("cacheLevelFull".equals(this.getCacheability())) {
            return WindowState.UNDEFINED;
        }
        return super.getWindowState();
    }
}

