/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.SecurityConstraint;
import org.apache.pluto.container.om.portlet.UserDataConstraint;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;
import org.apache.pluto.container.om.portlet.impl.UserDataConstraintImpl;

public class SecurityConstraintImpl
implements SecurityConstraint {
    private UserDataConstraint udc;
    private final List<DisplayName> dispNames = new ArrayList<DisplayName>();
    private final ArrayList<String> portletNames = new ArrayList();

    public SecurityConstraintImpl(SecurityConstraint sc) {
        this.udc = sc.getUserDataConstraint();
        for (DisplayName disp : sc.getDisplayNames()) {
            this.dispNames.add(new DisplayNameImpl(disp));
        }
        for (String pn : sc.getPortletNames()) {
            this.portletNames.add(new String(pn));
        }
    }

    public SecurityConstraintImpl(UserDataConstraint udc) {
        this.udc = new UserDataConstraintImpl(udc);
    }

    @Override
    public UserDataConstraint getUserDataConstraint() {
        return new UserDataConstraintImpl(this.udc);
    }

    @Override
    public DisplayName getDisplayName(Locale locale) {
        DisplayNameImpl ret = null;
        for (DisplayName item : this.dispNames) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DisplayNameImpl(item);
        }
        return ret;
    }

    @Override
    public List<DisplayName> getDisplayNames() {
        return new ArrayList<DisplayName>(this.dispNames);
    }

    @Override
    public void addDisplayName(DisplayName desc) {
        this.dispNames.add(desc);
    }

    @Override
    public List<String> getPortletNames() {
        return new ArrayList<String>(this.portletNames);
    }

    @Override
    public void addPortletName(String portletName) {
        this.portletNames.add(portletName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.udc == null ? 0 : this.udc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityConstraintImpl other = (SecurityConstraintImpl)obj;
        return !(this.udc == null ? other.udc != null : !this.udc.equals(other.udc));
    }
}

