/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;

public class ListenerImpl
implements Listener {
    private final List<Description> descs = new ArrayList<Description>();
    private final List<DisplayName> dispNames = new ArrayList<DisplayName>();
    private String listenerClass = "";
    private String listenerName = "";
    private int ordinal = 0;

    public ListenerImpl(Listener lis) {
        for (Description desc : lis.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
        for (DisplayName disp : lis.getDisplayNames()) {
            this.dispNames.add(new DisplayNameImpl(disp));
        }
        this.listenerClass = lis.getListenerClass();
        this.listenerName = lis.getListenerName();
        this.ordinal = lis.getOrdinal();
    }

    public ListenerImpl(String cls) {
        this.listenerClass = cls;
    }

    @Override
    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    @Override
    public DisplayName getDisplayName(Locale locale) {
        DisplayNameImpl ret = null;
        for (DisplayName item : this.dispNames) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DisplayNameImpl(item);
        }
        return ret;
    }

    @Override
    public List<DisplayName> getDisplayNames() {
        return new ArrayList<DisplayName>(this.dispNames);
    }

    @Override
    public void addDisplayName(DisplayName desc) {
        this.dispNames.add(desc);
    }

    @Override
    public String getListenerClass() {
        return this.listenerClass;
    }

    @Override
    public void setListenerClass(String filterClass) {
        this.listenerClass = filterClass;
    }

    @Override
    public String getListenerName() {
        return this.listenerName;
    }

    @Override
    public void setListenerName(String listenerName) {
        this.listenerName = listenerName;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.listenerClass == null ? 0 : this.listenerClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerImpl other = (ListenerImpl)obj;
        return !(this.listenerClass == null ? other.listenerClass != null : !this.listenerClass.equals(other.listenerClass));
    }
}

