/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.MutableRenderParameters;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.MutablePortletParametersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableRenderParametersImpl
extends MutablePortletParametersImpl
implements MutableRenderParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableRenderParametersImpl.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();
    private final Set<String> prpNames;

    public static final void load() {
        if (isTrace) {
            LOGGER.debug("Loaded.");
        }
    }

    public MutableRenderParametersImpl(PortletURLProvider urlProvider, String windowId) {
        super(urlProvider, windowId, PortletURLProvider.ParamType.RENDER);
        this.prpNames = urlProvider.getPublicParameterNames(windowId);
    }

    public MutableRenderParametersImpl(Map<String, String[]> params, String windowId, Set<String> prpNames) {
        super(params, windowId, PortletURLProvider.ParamType.RENDER);
        this.prpNames = new HashSet<String>(prpNames);
    }

    public MutableRenderParameters clone() {
        if (isTrace) {
            LOGGER.debug("Window ID: " + this.windowId + ", ParameterType: " + (Object)((Object)this.type));
        }
        MutableRenderParametersImpl map = new MutableRenderParametersImpl((Map<String, String[]>)this.params, this.windowId, this.prpNames);
        return map;
    }

    public void clearPrivate() {
        int ctr = this.params.size();
        if (this.urlProvider != null) {
            for (String name : this.params.keySet()) {
                if (this.prpNames.contains(name)) continue;
                this.urlProvider.removeParameter(this.windowId, name, this.type);
            }
        }
        this.params.keySet().retainAll(this.prpNames);
        ctr -= this.params.size();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", removed ").append(ctr).append(" values.");
            LOGGER.debug(txt.toString());
        }
    }

    public void clearPublic() {
        int ctr = this.params.size();
        if (this.urlProvider != null) {
            for (String name : this.params.keySet()) {
                if (!this.prpNames.contains(name)) continue;
                this.urlProvider.removePublicRenderParameter(this.windowId, name);
            }
        }
        this.params.keySet().removeAll(this.prpNames);
        ctr -= this.params.size();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", removed ").append(ctr).append(" values.");
            LOGGER.debug(txt.toString());
        }
    }

    public boolean isPublic(String name) {
        this.checkNull("name", name);
        boolean isPublic = this.prpNames.contains(name);
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", Name: ").append(name).append(", isPublic: ").append(isPublic);
            LOGGER.debug(txt.toString());
        }
        return isPublic;
    }
}

