/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.pluto.container.bean.processor.MethodType;
import org.apache.pluto.container.bean.processor.SignatureVariant;

public class MethodDescription {
    public static MethodDescription METH_INI = new MethodDescription(Void.TYPE, new Class[]{PortletConfig.class}, new Class[]{PortletException.class, IOException.class}, MethodType.INIT);
    public static MethodDescription METH_DES = new MethodDescription(Void.TYPE, new Class[0], new Class[0], MethodType.DESTROY);
    public static MethodDescription METH_ACT = new MethodDescription(Void.TYPE, new Class[]{ActionRequest.class, ActionResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.ACTION);
    public static MethodDescription METH_EVT = new MethodDescription(Void.TYPE, new Class[]{EventRequest.class, EventResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.EVENT);
    public static MethodDescription METH_REN = new MethodDescription(Void.TYPE, new Class[]{RenderRequest.class, RenderResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.RENDER);
    public static MethodDescription METH_RES;
    public static MethodDescription METH_HDR;
    private final Class<?> retType;
    private final Class<?>[] argTypes;
    private final Class<?>[] expTypes;
    private final MethodType type;
    private SignatureVariant variant = SignatureVariant.DEFAULT;
    private boolean checkExceptions = false;
    private boolean allowMultiple = false;
    private final StringBuilder errtxt = new StringBuilder(128);

    public MethodDescription(Class<?> rt, Class<?>[] at, Class<?>[] et, MethodType mt) {
        this.retType = rt;
        this.argTypes = at;
        this.expTypes = et;
        this.type = mt;
    }

    public Class<?>[] getArgTypes() {
        return this.argTypes;
    }

    public boolean isCheckExceptions() {
        return this.checkExceptions;
    }

    public void setCheckExceptions(boolean checkExceptions) {
        this.checkExceptions = checkExceptions;
    }

    public MethodType getType() {
        return this.type;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    public SignatureVariant getVariant() {
        return this.variant;
    }

    public void setVariant(SignatureVariant variant) {
        this.variant = variant;
    }

    public boolean isMethodMatched(Method meth) {
        boolean ok = true;
        this.errtxt.setLength(0);
        if (!this.retType.isAssignableFrom(meth.getReturnType())) {
            ok = false;
            this.errtxt.append("Unexpected return value. Actual: ").append(meth.getReturnType().getCanonicalName());
        }
        if (ok) {
            int ii;
            Class<?>[] types = meth.getParameterTypes();
            if (types.length != this.argTypes.length) {
                ok = false;
            } else {
                for (ii = 0; ii < types.length; ++ii) {
                    if (types[ii].isAssignableFrom(this.argTypes[ii])) continue;
                    ok = false;
                }
            }
            if (!ok) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (Class<?> c : types) {
                    tmp.add(c.getCanonicalName());
                }
                this.errtxt.append("Parameter type mismatch.  Actual: ").append(tmp.toString());
            }
            if (ok && this.checkExceptions) {
                types = meth.getExceptionTypes();
                if (types.length > this.expTypes.length) {
                    ok = false;
                } else {
                    for (ii = 0; ii < types.length && ok; ++ii) {
                        ok = false;
                        for (int jj = 0; jj < this.expTypes.length && !ok; ++jj) {
                            if (!this.expTypes[jj].isAssignableFrom(types[ii])) continue;
                            ok = true;
                        }
                    }
                }
                if (!ok) {
                    ArrayList<String> tmp = new ArrayList<String>();
                    for (Class<?> c : types) {
                        tmp.add(c.getCanonicalName());
                    }
                    this.errtxt.append("Exception type mismatch. Actual: ").append(tmp.toString());
                }
            }
        }
        return ok;
    }

    public String getExpectedSignature(boolean showErrorString) {
        if (!showErrorString) {
            this.errtxt.setLength(0);
        } else {
            this.errtxt.append(", Expected signature:\n");
        }
        this.errtxt.append(this.retType.getCanonicalName());
        this.errtxt.append(" &lt;name&gt;(");
        String sep = "";
        for (Class<?> c : this.argTypes) {
            this.errtxt.append(sep).append(c.getCanonicalName());
            sep = ", ";
        }
        this.errtxt.append(")");
        if (this.expTypes.length > 0) {
            this.errtxt.append(" throws ");
            sep = "";
            for (Class<?> c : this.expTypes) {
                this.errtxt.append(sep).append(c.getCanonicalName());
                sep = ", ";
            }
        }
        return this.errtxt.toString();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder(128);
        txt.append(this.getExpectedSignature(false));
        txt.append("/ type=").append((Object)this.type);
        txt.append(", variant=").append((Object)this.variant);
        txt.append(", checkExceptions=").append(this.checkExceptions);
        txt.append(", allowMultiple=").append(this.allowMultiple);
        return txt.toString();
    }

    static {
        METH_REN.setAllowMultiple(true);
        METH_REN.setVariant(SignatureVariant.VOID_RENDERREQ_RENDERRESP);
        METH_RES = new MethodDescription(Void.TYPE, new Class[]{ResourceRequest.class, ResourceResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.RESOURCE);
        METH_RES.setAllowMultiple(true);
        METH_RES.setVariant(SignatureVariant.VOID_RESOURCEREQ_RESOURCERESP);
        METH_HDR = new MethodDescription(Void.TYPE, new Class[]{HeaderRequest.class, HeaderResponse.class}, new Class[]{PortletException.class, IOException.class}, MethodType.HEADER);
        METH_HDR.setAllowMultiple(true);
        METH_HDR.setVariant(SignatureVariant.VOID_HEADERREQ_HEADERRESP);
    }
}

