/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.scheduler;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.jetspeed.scheduler.AbstractScheduler;
import org.apache.jetspeed.scheduler.JobEntry;
import org.apache.jetspeed.scheduler.JobQueue;
import org.apache.jetspeed.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBasedScheduler
extends AbstractScheduler
implements Scheduler {
    private static final Logger log = LoggerFactory.getLogger(MemoryBasedScheduler.class);
    private Configuration config;

    public MemoryBasedScheduler(Configuration config) throws Exception {
        this.config = config;
    }

    private Configuration getConfiguration() {
        return this.config;
    }

    public void start() {
        try {
            super.start();
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new AbstractScheduler.MainLoop();
            List jobProps = this.getConfiguration().getList("jobs");
            ArrayList<JobEntry> jobs = new ArrayList<JobEntry>();
            if (!jobProps.isEmpty()) {
                for (int i = 0; i < jobProps.size(); ++i) {
                    String jobName = (String)jobProps.get(i);
                    String jobPrefix = "job." + jobName;
                    if (this.getConfiguration().getString(jobPrefix + ".ID", null) == null) {
                        throw new Exception("There is an error in the properties file. \n" + jobPrefix + ".ID is not found.\n");
                    }
                    int sec = this.getConfiguration().getInt(jobPrefix + ".SECOND", -1);
                    int min = this.getConfiguration().getInt(jobPrefix + ".MINUTE", -1);
                    int hr = this.getConfiguration().getInt(jobPrefix + ".HOUR", -1);
                    int wkday = this.getConfiguration().getInt(jobPrefix + ".WEEKDAY", -1);
                    int dayOfMonth = this.getConfiguration().getInt(jobPrefix + ".DAY_OF_MONTH", -1);
                    JobEntry je = new JobEntry(sec, min, hr, wkday, dayOfMonth, jobName);
                    jobs.add(je);
                }
            }
            if (jobs != null && jobs.size() > 0) {
                this.scheduleQueue.batchLoad(jobs);
                this.restart();
            }
        }
        catch (Exception e) {
            log.error("Cannot initialize SchedulerService!: ", (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
    }

    public JobEntry getJob(int oid) throws Exception {
        JobEntry je = new JobEntry(-1, -1, -1, -1, -1, null);
        return this.scheduleQueue.getJob(je);
    }

    public void addJob(JobEntry je) throws Exception {
        this.scheduleQueue.add(je);
        this.restart();
    }

    public void removeJob(JobEntry je) throws Exception {
        this.scheduleQueue.remove(je);
        this.restart();
    }

    public void updateJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
        }
        catch (Exception e) {
            log.error("Problem updating Scheduled Job: " + e);
        }
        this.scheduleQueue.modify(je);
        this.restart();
    }
}

