/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.statistics.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jetspeed.statistics.impl.BatchedStatistics;
import org.apache.jetspeed.statistics.impl.LogRecord;
import org.apache.jetspeed.statistics.impl.UserLogRecord;

public class BatchedUserStatistics
extends BatchedStatistics {
    public boolean canDoRecordType(LogRecord rec) {
        return rec instanceof UserLogRecord;
    }

    public BatchedUserStatistics(DataSource ds, int batchSize, long msElapsedTimeThreshold, String name) {
        super(ds, batchSize, msElapsedTimeThreshold, name);
    }

    protected void loadOneRecordToStatement(PreparedStatement stm, LogRecord rec) throws SQLException {
        UserLogRecord record = (UserLogRecord)rec;
        stm.setString(1, record.getIpAddress());
        stm.setString(2, record.getUserName());
        stm.setTimestamp(3, record.getTimeStamp());
        stm.setInt(4, record.getStatus());
        stm.setLong(5, record.getMsElapsedTime());
    }

    protected PreparedStatement getPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stm = con.prepareStatement("INSERT INTO USER_STATISTICS VALUES(?,?,?,?,?)");
        return stm;
    }
}

