/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jetspeed.tools.migration.JetspeedMigration;
import org.apache.jetspeed.tools.migration.JetspeedMigrationListener;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResult;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResultImpl;

public class JetspeedSSOSecurityMigration
implements JetspeedMigration {
    public String getName() {
        return "SSO Security";
    }

    public int detectSourceVersion(Connection sourceConnection, int sourceVersion) throws SQLException {
        int sourceSecurityVersion = 213;
        try {
            Statement securityDomainQueryStatement = sourceConnection.createStatement();
            securityDomainQueryStatement.executeQuery("SELECT DOMAIN_ID FROM SSO_SITE WHERE SITE_ID = 0");
            sourceSecurityVersion = 220;
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        return sourceSecurityVersion >= sourceVersion ? sourceSecurityVersion : sourceVersion;
    }

    public JetspeedMigrationResult migrate(Connection sourceConnection, int sourceVersion, Connection targetConnection, JetspeedMigrationListener migrationListener) throws SQLException {
        int rowsMigrated = 0;
        PreparedStatement ssoSiteInsertStatement = targetConnection.prepareStatement("INSERT INTO SSO_SITE (SITE_ID, NAME, URL, ALLOW_USER_SET, REQUIRES_CERTIFICATE, CHALLENGE_RESPONSE_AUTH, FORM_AUTH, FORM_USER_FIELD, FORM_PWD_FIELD, REALM, DOMAIN_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Statement ssoSiteQueryStatement = sourceConnection.createStatement();
        ssoSiteQueryStatement.setFetchSize(10000);
        ResultSet ssoSiteResultSet = null;
        switch (sourceVersion) {
            case 213: 
            case 214: {
                ssoSiteResultSet = ssoSiteQueryStatement.executeQuery("SELECT SITE_ID, NAME, URL, ALLOW_USER_SET, REQUIRES_CERTIFICATE, CHALLENGE_RESPONSE_AUTH, FORM_AUTH, FORM_USER_FIELD, FORM_PWD_FIELD, REALM FROM SSO_SITE");
                PreparedStatement domainQueryStatement = targetConnection.prepareStatement("SELECT DOMAIN_ID FROM SECURITY_DOMAIN WHERE DOMAIN_NAME = ?");
                while (ssoSiteResultSet.next()) {
                    String name = ssoSiteResultSet.getString(2);
                    int domainId = 0;
                    domainQueryStatement.setString(1, name);
                    ResultSet domainResultSet = domainQueryStatement.executeQuery();
                    if (!domainResultSet.next()) {
                        throw new SQLException("Unable to find security domain id for SSO site: " + name);
                    }
                    domainId = domainResultSet.getInt(1);
                    domainResultSet.close();
                    ssoSiteInsertStatement.setInt(1, ssoSiteResultSet.getInt(1));
                    ssoSiteInsertStatement.setString(2, name);
                    ssoSiteInsertStatement.setString(3, ssoSiteResultSet.getString(3));
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)4, (PreparedStatement)ssoSiteInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)5, (PreparedStatement)ssoSiteInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)6, (PreparedStatement)ssoSiteInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)7, (PreparedStatement)ssoSiteInsertStatement);
                    ssoSiteInsertStatement.setString(8, ssoSiteResultSet.getString(8));
                    ssoSiteInsertStatement.setString(9, ssoSiteResultSet.getString(9));
                    ssoSiteInsertStatement.setString(10, ssoSiteResultSet.getString(10));
                    ssoSiteInsertStatement.setInt(11, domainId);
                    ssoSiteInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                domainQueryStatement.close();
                break;
            }
            case 220: 
            case 221: {
                ssoSiteResultSet = ssoSiteQueryStatement.executeQuery("SELECT SITE_ID, NAME, URL, ALLOW_USER_SET, REQUIRES_CERTIFICATE, CHALLENGE_RESPONSE_AUTH, FORM_AUTH, FORM_USER_FIELD, FORM_PWD_FIELD, REALM, DOMAIN_ID FROM SSO_SITE");
                while (ssoSiteResultSet.next()) {
                    ssoSiteInsertStatement.setInt(1, ssoSiteResultSet.getInt(1));
                    ssoSiteInsertStatement.setString(2, ssoSiteResultSet.getString(2));
                    ssoSiteInsertStatement.setString(3, ssoSiteResultSet.getString(3));
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)4, (PreparedStatement)ssoSiteInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)5, (PreparedStatement)ssoSiteInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)6, (PreparedStatement)ssoSiteInsertStatement);
                    JetspeedMigration.Static.setNullableShort((ResultSet)ssoSiteResultSet, (int)7, (PreparedStatement)ssoSiteInsertStatement);
                    ssoSiteInsertStatement.setString(8, ssoSiteResultSet.getString(8));
                    ssoSiteInsertStatement.setString(9, ssoSiteResultSet.getString(9));
                    ssoSiteInsertStatement.setString(10, ssoSiteResultSet.getString(10));
                    ssoSiteInsertStatement.setInt(11, ssoSiteResultSet.getInt(11));
                    ssoSiteInsertStatement.executeUpdate();
                    ++rowsMigrated;
                    migrationListener.rowMigrated(targetConnection);
                }
                break;
            }
        }
        ssoSiteResultSet.close();
        ssoSiteQueryStatement.close();
        ssoSiteInsertStatement.close();
        PreparedStatement ojbInsertStatement = targetConnection.prepareStatement("INSERT INTO OJB_HL_SEQ (TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION) VALUES (?, ?, ?, ?, ?)");
        Statement ojbQueryStatement = sourceConnection.createStatement();
        ResultSet ojbResultSet = ojbQueryStatement.executeQuery("SELECT TABLENAME, FIELDNAME, MAX_KEY, GRAB_SIZE, VERSION FROM OJB_HL_SEQ WHERE TABLENAME IN ('SEQ_SSO_SITE')");
        while (ojbResultSet.next()) {
            ojbInsertStatement.setString(1, ojbResultSet.getString(1));
            ojbInsertStatement.setString(2, ojbResultSet.getString(2));
            ojbInsertStatement.setInt(3, ojbResultSet.getInt(3));
            ojbInsertStatement.setInt(4, ojbResultSet.getInt(4));
            ojbInsertStatement.setInt(5, ojbResultSet.getInt(5));
            ojbInsertStatement.executeUpdate();
            ++rowsMigrated;
            migrationListener.rowMigrated(targetConnection);
        }
        ojbResultSet.close();
        ojbQueryStatement.close();
        ojbInsertStatement.close();
        return new JetspeedMigrationResultImpl(rowsMigrated);
    }
}

