/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityDomain;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.SecurityDomainImpl;
import org.apache.jetspeed.security.spi.SecurityDomainAccessManager;
import org.apache.jetspeed.security.spi.SecurityDomainStorageManager;
import org.apache.jetspeed.security.spi.impl.PasswordCredentialImpl;
import org.apache.jetspeed.sso.SSOClient;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.jetspeed.sso.impl.SSOClientImpl;
import org.apache.jetspeed.sso.impl.SSOSiteImpl;
import org.apache.jetspeed.sso.spi.SSOSiteManagerSPI;
import org.apache.jetspeed.sso.spi.SSOUserManagerSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOManagerImpl
implements SSOManager {
    private static final Logger log = LoggerFactory.getLogger(SSOManagerImpl.class);
    private UserManager userManager;
    private SSOUserManagerSPI ssoUserManagerSPI;
    private SecurityDomainAccessManager domainAccessManager;
    private SecurityDomainStorageManager domainStorageManager;
    private SSOSiteManagerSPI ssoSiteManagerSPI;
    private Long defaultDomainId;

    public SSOClient getClient(SSOSite site, SSOUser remoteUser) throws SSOException {
        PasswordCredential pwdCred = this.getCredentials(remoteUser);
        return new SSOClientImpl(site, pwdCred);
    }

    protected User getUser(String username) {
        User user = null;
        try {
            user = this.userManager.getUser(username);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return user;
    }

    protected Collection<SSOUser> getRemoteUsers(JetspeedPrincipal p) throws SSOException {
        try {
            return this.ssoUserManagerSPI.getUsers(p);
        }
        catch (SecurityException secex) {
            throw new SSOException((Throwable)secex);
        }
    }

    public Collection<SSOUser> getRemoteUsers(SSOSite site, Subject subject) throws SSOException {
        HashMap<Long, SSOUser> resultUsers = new HashMap<Long, SSOUser>();
        for (Principal p : subject.getPrincipals()) {
            if (!(p instanceof JetspeedPrincipal)) continue;
            try {
                Collection<SSOUser> usersForThisPrincipal = this.getRemoteUsers(site, (JetspeedPrincipal)p);
                for (SSOUser user : usersForThisPrincipal) {
                    if (resultUsers.containsKey(user.getId())) continue;
                    resultUsers.put(user.getId(), user);
                }
            }
            catch (SSOException se) {
                throw new SSOException((Throwable)se);
            }
        }
        return resultUsers.values();
    }

    public Collection<SSOUser> getRemoteUsers(SSOSite site, JetspeedPrincipal portalPrincipal) throws SSOException {
        try {
            return this.ssoUserManagerSPI.getUsers(portalPrincipal, site.getSecurityDomainId());
        }
        catch (SecurityException secex) {
            throw new SSOException((Throwable)secex);
        }
    }

    public void setPassword(SSOUser user, String pwd) throws SSOException {
        PasswordCredential pwdCred = null;
        try {
            pwdCred = this.ssoUserManagerSPI.getPasswordCredential(user);
        }
        catch (SecurityException secex) {
            // empty catch block
        }
        if (pwdCred != null) {
            pwdCred.setPassword(pwd, false);
        } else {
            pwdCred = new PasswordCredentialImpl((User)user, pwd);
        }
        try {
            this.ssoUserManagerSPI.storePasswordCredential(pwdCred);
        }
        catch (SecurityException sx) {
            throw new SSOException((Throwable)sx);
        }
    }

    public Collection<JetspeedPrincipal> getPortalPrincipals(SSOUser user) {
        SSOSite site = this.ssoSiteManagerSPI.getSite(user);
        if (site != null) {
            SecurityDomain ssoDomain = this.domainAccessManager.getDomain(site.getSecurityDomainId());
            SecurityDomain ownerDomain = this.domainAccessManager.getDomain(ssoDomain.getOwnerDomainId());
            return this.ssoUserManagerSPI.getPortalPrincipals(user, ownerDomain.getDomainId());
        }
        return Collections.emptyList();
    }

    protected Long getDefaultDomainId() {
        if (this.defaultDomainId == null) {
            SecurityDomain domain = this.domainAccessManager.getDomainByName("[default]");
            if (domain == null) {
                throw new RuntimeException("Could not find default security domain.");
            }
            this.defaultDomainId = domain.getDomainId();
        }
        return this.defaultDomainId;
    }

    public SSOSite addSite(SSOSite site) throws SSOException {
        return this.addSite(this.getDefaultDomainId(), site);
    }

    protected SSOSite addSite(Long ownerDomainId, SSOSite site) throws SSOException {
        if (this.domainAccessManager.getDomainByName(site.getName()) != null) {
            throw new SSOException("The site could not be created because a site with the same name exists.");
        }
        SecurityDomainImpl sd = new SecurityDomainImpl();
        sd.setName(site.getName());
        sd.setOwnerDomainId(ownerDomainId);
        sd.setEnabled(true);
        sd.setRemote(true);
        try {
            this.domainStorageManager.addDomain((SecurityDomain)sd);
        }
        catch (SecurityException sx) {
            log.error("Could not add remote security domain with name " + site.getName() + " for owner domain " + ownerDomainId);
            throw new SSOException("The site could not be created.", (Throwable)sx);
        }
        SecurityDomain storedDomain = this.domainAccessManager.getDomainByName(site.getName());
        if (storedDomain == null || storedDomain.getDomainId() == null) {
            throw new SSOException("The site could not be created.");
        }
        site.setSecurityDomainId(storedDomain.getDomainId());
        try {
            return this.ssoSiteManagerSPI.add(site);
        }
        catch (SSOException se) {
            try {
                this.domainStorageManager.removeDomain(storedDomain);
            }
            catch (SecurityException secex) {
                // empty catch block
            }
            throw new SSOException((Throwable)se);
        }
    }

    public PasswordCredential getCredentials(SSOUser user) throws SSOException {
        try {
            return this.ssoUserManagerSPI.getPasswordCredential(user);
        }
        catch (SecurityException secex) {
            throw new SSOException((Throwable)secex);
        }
    }

    public Collection<SSOSite> getSites(String filter) {
        return this.ssoSiteManagerSPI.getSites(filter);
    }

    public Collection<SSOUser> getUsersForSite(SSOSite site) throws SSOException {
        try {
            return this.ssoUserManagerSPI.getUsers("", site.getSecurityDomainId());
        }
        catch (SecurityException e) {
            throw new SSOException("Could not fetch SSO users for site " + site.getName(), (Throwable)e);
        }
    }

    public Collection<SSOSite> getSitesForPrincipal(JetspeedPrincipal localPrincipal) throws SSOException {
        Collection<SSOUser> ssoUsers;
        Collection<Object> sitesFound = null;
        if (localPrincipal != null && (ssoUsers = this.getRemoteUsers(localPrincipal)) != null && ssoUsers.size() > 0) {
            sitesFound = this.ssoSiteManagerSPI.getSites(ssoUsers);
        }
        return sitesFound != null ? sitesFound : Collections.EMPTY_SET;
    }

    public Collection<SSOSite> getSitesForSubject(Subject subject) throws SSOException {
        HashMap<Integer, SSOSite> siteIdToSite = new HashMap<Integer, SSOSite>();
        for (Principal p : subject.getPrincipals()) {
            if (!(p instanceof JetspeedPrincipal)) continue;
            try {
                Collection<SSOSite> sitesForThisPrincipal = this.getSitesForPrincipal((JetspeedPrincipal)p);
                for (SSOSite site : sitesForThisPrincipal) {
                    if (siteIdToSite.containsKey(site.getId())) continue;
                    siteIdToSite.put(site.getId(), site);
                }
            }
            catch (SSOException se) {
            }
        }
        return siteIdToSite.values();
    }

    public void addAssociation(SSOUser user, JetspeedPrincipal principal) throws SSOException {
        try {
            this.ssoUserManagerSPI.addSSOUserToPrincipal(user, principal);
        }
        catch (SecurityException secex) {
            throw new SSOException("Unable to associate principal " + principal.getName() + " with SSO user " + user.getName());
        }
    }

    public SSOUser addUser(SSOSite site, JetspeedPrincipal ownerPrincipal, String ssoUsername, String ssoUserPassword) throws SSOException {
        SSOUser newUser = null;
        try {
            newUser = this.ssoUserManagerSPI.addUser(ssoUsername, site.getSecurityDomainId(), ownerPrincipal);
            this.setPassword(newUser, ssoUserPassword);
            this.addAssociation(newUser, ownerPrincipal);
        }
        catch (SecurityException secex) {
            if (newUser != null) {
                this.removeUser(newUser);
            }
            throw new SSOException("Unable to add new SSO User " + ssoUsername, (Throwable)secex);
        }
        return newUser;
    }

    public void updateUser(SSOUser user) throws SSOException {
        try {
            this.ssoUserManagerSPI.updateUser(user);
        }
        catch (SecurityException secex) {
            throw new SSOException("Unable to update user:", (Throwable)secex);
        }
    }

    public void removeUser(SSOUser remoteUser) throws SSOException {
        try {
            this.ssoUserManagerSPI.removeUser(remoteUser.getName(), remoteUser.getDomainId());
        }
        catch (SecurityException secex) {
            throw new SSOException("Unable to remove SSO User " + remoteUser.getName(), (Throwable)secex);
        }
    }

    public void removeSite(SSOSite site) throws SSOException {
        SecurityDomain domain = this.domainAccessManager.getDomain(site.getSecurityDomainId());
        if (domain != null) {
            try {
                this.domainStorageManager.removeDomain(domain);
            }
            catch (SecurityException secex) {
                throw new SSOException("Unable to remove security domain (id:" + site.getSecurityDomainId() + ") associated with the SSO Site " + site.getName());
            }
        }
        this.ssoSiteManagerSPI.remove(site);
    }

    public void updateSite(SSOSite site) throws SSOException {
        SSOSite currentSite = this.ssoSiteManagerSPI.getById(site.getId());
        if (currentSite == null) {
            throw new SSOException("Unable to update site: site doesn't exist.");
        }
        if (!currentSite.getName().equals(site.getName())) {
            if (this.domainAccessManager.getDomainByName(site.getName()) != null) {
                throw new SSOException("Unable to rename site to '" + site.getName() + "': a security domain with that name already exists!");
            }
            SecurityDomain domain = this.domainAccessManager.getDomain(currentSite.getSecurityDomainId());
            SecurityDomainImpl renamedDomain = new SecurityDomainImpl(domain);
            renamedDomain.setName(site.getName());
            try {
                this.domainStorageManager.updateDomain((SecurityDomain)renamedDomain);
            }
            catch (SecurityException secex) {
                throw new SSOException("Unable to rename security domain " + domain.getName() + " to " + site.getName() + ".", (Throwable)secex);
            }
        }
        this.ssoSiteManagerSPI.update(site);
    }

    public SSOUser getRemoteUser(SSOSite site, String remoteUsername) {
        try {
            return this.ssoUserManagerSPI.getUser(remoteUsername, site.getSecurityDomainId());
        }
        catch (SecurityException secex) {
            log.debug("Could not find SSO user with name " + remoteUsername + " from remote site " + site.getName() + " (domain id: " + site.getSecurityDomainId() + ")", (Throwable)secex);
            return null;
        }
    }

    public SSOSite getSiteByUrl(String siteUrl) {
        return this.ssoSiteManagerSPI.getByUrl(siteUrl);
    }

    public SSOSite getSiteByName(String siteName) {
        return this.ssoSiteManagerSPI.getByName(siteName);
    }

    public SSOSite getSiteById(int id) {
        return this.ssoSiteManagerSPI.getById(id);
    }

    public SSOSite newSite(String name, String url) {
        return new SSOSiteImpl(name, url);
    }

    public void setUserManager(UserManager userMan) {
        this.userManager = userMan;
    }

    public void setSSOUserManagerSPI(SSOUserManagerSPI ssoUserManSPI) {
        this.ssoUserManagerSPI = ssoUserManSPI;
    }

    public void setDomainAccessManager(SecurityDomainAccessManager domainAccess) {
        this.domainAccessManager = domainAccess;
    }

    public void setDomainStorageManager(SecurityDomainStorageManager domainStore) {
        this.domainStorageManager = domainStore;
    }

    public void setSSOSiteManagerSPI(SSOSiteManagerSPI ssoSiteManSPI) {
        this.ssoSiteManagerSPI = ssoSiteManSPI;
    }
}

