/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.sso.SSOClient;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.impl.SSOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOClientImpl
implements SSOClient {
    private static final Logger log = LoggerFactory.getLogger(SSOClientImpl.class);
    private SSOSite site;
    private PasswordCredential credential;
    private HttpClient httpClient;

    public SSOClientImpl(SSOSite site, PasswordCredential credential) {
        this.credential = credential;
        this.site = site;
    }

    public String get(String destUrl, boolean refreshProxy) throws SSOException {
        StringWriter sw = new StringWriter();
        this.write(destUrl, refreshProxy, sw);
        return sw.toString();
    }

    public void write(String destUrl, boolean refreshProxy, Writer out) throws SSOException {
        GetMethod get = null;
        if (refreshProxy || this.httpClient == null) {
            get = new GetMethod(this.site.getURL());
            this.login(get);
            if (destUrl.compareTo(this.site.getURL()) == 0) {
                try {
                    IOUtils.copy((InputStream)get.getResponseBodyAsStream(), (Writer)out);
                }
                catch (IOException ioe) {
                    log.error("Error while reading response from remote site at " + destUrl);
                }
                get.releaseConnection();
                return;
            }
            get.releaseConnection();
        }
        get = new GetMethod(destUrl);
        try {
            this.httpClient.executeMethod((HttpMethod)get);
        }
        catch (Exception e) {
            log.error("Exception while fetching SSO content. Error: " + e);
        }
        try {
            IOUtils.copy((InputStream)get.getResponseBodyAsStream(), (Writer)out);
        }
        catch (IOException ioe) {
            throw new SSOException("SSO Component Error. Failed to get content for URL " + destUrl, (Throwable)ioe);
        }
        catch (Exception e) {
            throw new SSOException("SSO Component Error. Failed to get content for URL " + destUrl, (Throwable)e);
        }
        get.releaseConnection();
    }

    public boolean login() throws SSOException {
        GetMethod get = new GetMethod(this.site.getURL().toString());
        int status = this.login(get);
        get.releaseConnection();
        return status >= 200 && status < 300;
    }

    private int login(GetMethod get) throws SSOException {
        URL url = null;
        try {
            url = new URL(this.site.getURL());
        }
        catch (MalformedURLException muex) {
            log.error(muex.getMessage(), (Throwable)muex);
            throw new SSOException("SSO: Marlformed url: " + this.site.getURL());
        }
        this.httpClient = new HttpClient();
        this.httpClient.getState().setCookiePolicy(0);
        this.httpClient.getState().setCredentials(this.site.getRealm(), url.getHost(), (Credentials)new UsernamePasswordCredentials(this.credential.getUserName(), SSOUtils.unscramble(this.credential.getPassword())));
        StringBuffer siteURL = new StringBuffer(this.site.getURL());
        if (this.site.isFormAuthentication()) {
            siteURL.append("?").append(this.site.getFormUserField()).append("=").append(this.credential.getUserName()).append("&").append(this.site.getFormPwdField()).append("=").append(SSOUtils.unscramble(this.credential.getPassword()));
        }
        get.setDoAuthentication(true);
        int status = -1;
        try {
            status = this.httpClient.executeMethod((HttpMethod)get);
        }
        catch (IOException ioe) {
            log.error("SSO: Error executing get method for url " + this.site.getURL());
            throw new SSOException((Throwable)ioe);
        }
        return status;
    }
}

