/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.security.Credential;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.serializer.objects.JSNVPElement;
import org.apache.jetspeed.serializer.objects.JSPWAttributes;
import org.apache.jetspeed.serializer.objects.JSPrincipalRules;
import org.apache.jetspeed.serializer.objects.JSSecurityAttributes;

public class JSPrincipal {
    private String type;
    private String name;
    private boolean mapped;
    private boolean enabled;
    private boolean readonly;
    private boolean removable;
    private boolean extendable;
    private JSSecurityAttributes secAttrs = new JSSecurityAttributes();
    private JSPWAttributes pwData;
    private List<Credential> publicCredentials;
    private List<Credential> privateCredentials;
    private transient Principal principal;
    private JSPrincipalRules rules = new JSPrincipalRules();
    private static final XMLFormat XML = new XMLFormat(JSPrincipal.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSPrincipal p = (JSPrincipal)o;
                xml.setAttribute("type", p.getType());
                xml.setAttribute("name", p.getName());
                xml.setAttribute("mapped", p.isMapped());
                xml.setAttribute("enabled", p.isEnabled());
                xml.setAttribute("readonly", p.isReadonly());
                xml.setAttribute("removable", p.isRemovable());
                xml.setAttribute("extendable", p.isExtendable());
                if (p.pwData != null) {
                    xml.add((Object)p.pwData);
                }
                if (p.secAttrs != null && p.secAttrs.size() > 0) {
                    xml.add((Object)p.secAttrs);
                }
                if (p.rules != null && p.rules.size() > 0) {
                    xml.add((Object)p.rules);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSPrincipal p = (JSPrincipal)o;
                p.setType(xml.getAttribute("type", ""));
                p.setName(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", "")));
                p.mapped = xml.getAttribute("mapped", false);
                p.enabled = xml.getAttribute("enabled", true);
                p.readonly = xml.getAttribute("readonly", false);
                p.removable = xml.getAttribute("removable", true);
                p.extendable = xml.getAttribute("extendable", true);
                Object o1 = null;
                while (xml.hasNext()) {
                    o1 = xml.getNext();
                    if (o1 instanceof JSSecurityAttributes) {
                        p.secAttrs = (JSSecurityAttributes)o1;
                        continue;
                    }
                    if (o1 instanceof JSPWAttributes) {
                        p.pwData = (JSPWAttributes)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSPrincipalRules)) continue;
                    p.rules = (JSPrincipalRules)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void setRemovable(boolean removable) {
        this.removable = removable;
    }

    public void setExtendable(boolean extendable) {
        this.extendable = extendable;
    }

    public boolean isExtendable() {
        return this.extendable;
    }

    public JSSecurityAttributes getSecurityAttributes() {
        return this.secAttrs;
    }

    public void setSecurityAttributes(Map<String, SecurityAttribute> sa) {
        for (Map.Entry<String, SecurityAttribute> e : sa.entrySet()) {
            SecurityAttribute attrib = e.getValue();
            JSNVPElement element = new JSNVPElement(attrib.getName(), attrib.getStringValue());
            element.setReadOnly(attrib.isReadOnly());
            element.setAttribute("datatype", attrib.getDataType().name());
            element.setAttribute("registered", Boolean.toString(attrib.isRegistered()));
            element.setAttribute("required", Boolean.toString(attrib.isRequired()));
            element.setAttribute("category", attrib.getCategory());
            this.secAttrs.add(element);
        }
    }

    public void setCredential(String name, char[] password, Date expirationDate, boolean isEnabled, boolean isExpired, boolean requireUpdate) {
        this.setName(name);
        this.pwData = new JSPWAttributes();
        if (password != null) {
            String passwordString = password.length > 0 ? new String(password) : "";
            this.pwData.getMyMap().put("password", passwordString);
            if (expirationDate != null) {
                this.pwData.getMyMap().put("expirationDate", expirationDate.toString());
            }
            this.pwData.getMyMap().put("enabled", Boolean.toString(isEnabled));
            this.pwData.getMyMap().put("requiresUpdate", Boolean.toString(requireUpdate));
        }
    }

    public JSPWAttributes getPwData() {
        return this.pwData;
    }

    public String getPwDataValue(String key) {
        return this.getPwDataValue(key, null);
    }

    public String getPwDataValue(String key, String defValue) {
        String value = this.pwData != null ? this.pwData.getMyMap().get(key) : null;
        return value != null ? value : defValue;
    }

    public boolean getPwDataValueAsBoolean(String key) {
        return this.getPwDataValueAsBoolean(key, false);
    }

    public boolean getPwDataValueAsBoolean(String key, boolean defValue) {
        String sv = this.getPwDataValue(key);
        return sv != null ? Boolean.parseBoolean(sv) : defValue;
    }

    public Date getPwDataValueAsDate(String key) {
        return this.getPwDataValueAsDate(key, null);
    }

    public Date getPwDataValueAsDate(String key, Date defValue) {
        Date value = null;
        String sv = this.getPwDataValue(key, null);
        if (sv != null) {
            value = Date.valueOf(sv);
        }
        return value != null ? value : defValue;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public JSPrincipalRules getRules() {
        return this.rules;
    }

    public void setRules(JSPrincipalRules rules) {
        this.rules = rules;
    }

    public List<Credential> getPrivateCredentials() {
        return this.privateCredentials;
    }

    public void setPrivateCredentials(List<Credential> privateCredentials) {
        this.privateCredentials = privateCredentials;
    }

    public List<Credential> getPublicCredentials() {
        return this.publicCredentials;
    }

    public void setPublicCredentials(List<Credential> publicCredentials) {
        this.publicCredentials = publicCredentials;
    }

    public void addPublicCredential(Credential o) {
        if (this.publicCredentials == null) {
            this.publicCredentials = new ArrayList<Credential>();
        }
        this.publicCredentials.add(o);
    }

    public void addPrivateCredential(Credential o) {
        if (this.privateCredentials == null) {
            this.privateCredentials = new ArrayList<Credential>();
        }
        this.privateCredentials.add(o);
    }
}

