/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.ArrayList;
import java.util.List;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.serializer.objects.JSPrincipal;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;
import org.apache.jetspeed.serializer.objects.JSUserUsers;

public class JSPermission {
    private String type;
    private String resource;
    private String actions;
    private long id;
    private List<JSPrincipal> roles = null;
    private List<JSPrincipal> groups = null;
    private List<JSPrincipal> users = null;
    private JSUserRoles roleString;
    private JSUserGroups groupString;
    private JSUserUsers userString;
    public static final String TYPE_FOLDER = "folder".intern();
    public static final String TYPE_FRAGMENT = "fragment".intern();
    public static final String TYPE_PAGE = "page".intern();
    public static final String TYPE_PORTALRESOURCE = "portalResource".intern();
    public static final String TYPE_PORTALRESOURCECOLLECTION = "portalResource".intern();
    public static final String TYPE_PORTAL = "portal".intern();
    public static final String TYPE_UNKNOWN = "unknown".intern();
    private static final XMLFormat XML = new XMLFormat(JSPermission.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSPermission g = (JSPermission)o;
                xml.setAttribute("type", g.getType());
                xml.setAttribute("resource", g.getResource());
                xml.setAttribute("actions", g.getActions());
                g.groupString = new JSUserGroups(g.putTokens(g.getGroups()));
                g.roleString = new JSUserRoles(g.putTokens(g.getRoles()));
                g.userString = new JSUserUsers(g.putTokens(g.getUsers()));
                xml.add((Object)g.roleString);
                xml.add((Object)g.groupString);
                xml.add((Object)g.userString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSPermission g = (JSPermission)o;
                g.type = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("type", "type_unknown"));
                g.resource = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("resource", "resource_unknown"));
                g.actions = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("actions", "unknown_actions"));
                while (xml.hasNext()) {
                    Object o1 = xml.getNext();
                    if (o1 instanceof JSUserGroups) {
                        g.groupString = (JSUserGroups)o1;
                        continue;
                    }
                    if (o1 instanceof JSUserUsers) {
                        g.userString = (JSUserUsers)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSUserRoles)) continue;
                    g.roleString = (JSUserRoles)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private String putTokens(List<JSPrincipal> _list) {
        if (_list == null || _list.size() == 0) {
            return "";
        }
        boolean _start = true;
        StringBuffer _sb = new StringBuffer();
        for (JSPrincipal jsPrincipal : _list) {
            if (!_start) {
                _sb.append(',');
            } else {
                _start = false;
            }
            _sb.append(jsPrincipal.getName());
        }
        return _sb.toString();
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public List<JSPrincipal> getGroups() {
        return this.groups;
    }

    public void setGroups(List<JSPrincipal> groups) {
        this.groups = groups;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public List<JSPrincipal> getRoles() {
        return this.roles;
    }

    public void setRoles(List<JSPrincipal> roles) {
        this.roles = roles;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<JSPrincipal> getUsers() {
        return this.users;
    }

    public void setUsers(List<JSPrincipal> users) {
        this.users = users;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addGroup(JSPrincipal group) {
        if (this.groups == null) {
            this.groups = new ArrayList<JSPrincipal>();
        }
        this.groups.add(group);
    }

    public void addRole(JSPrincipal role) {
        if (this.roles == null) {
            this.roles = new ArrayList<JSPrincipal>();
        }
        this.roles.add(role);
    }

    public void addUser(JSPrincipal user) {
        if (this.users == null) {
            this.users = new ArrayList<JSPrincipal>();
        }
        this.users.add(user);
    }

    public JSUserGroups getGroupString() {
        return this.groupString;
    }

    public JSUserRoles getRoleString() {
        return this.roleString;
    }

    public JSUserUsers getUserString() {
        return this.userString;
    }
}

