/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.security.Principal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.jetspeed.serializer.objects.JSNVPElements;
import org.apache.jetspeed.serializer.objects.JSPWAttributes;
import org.apache.jetspeed.serializer.objects.JSPrincipalRules;
import org.apache.jetspeed.serializer.objects.JSRole;
import org.apache.jetspeed.serializer.objects.JSUserAttributes;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;

public class JSUser {
    private String name;
    private char[] password;
    private JSPWAttributes pwData = null;
    private ArrayList roles = null;
    private ArrayList groups = null;
    private JSUserAttributes userInfo = null;
    private JSNVPElements preferences = null;
    private ArrayList publicCredentials = null;
    private ArrayList privateCredentials = null;
    private JSUserRoles roleString;
    private JSUserGroups groupString;
    private JSPrincipalRules rules = new JSPrincipalRules();
    private transient Principal principal;
    private static final XMLFormat XML = new XMLFormat(JSUser.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSUser g = (JSUser)o;
                String s = g.getName();
                if (s == null || s.length() == 0) {
                    s = "guest";
                }
                xml.setAttribute("name", s);
                xml.add((Object)g.getPwData());
                g.groupString = new JSUserGroups(g.putTokens(g.getGroups()));
                g.roleString = new JSUserRoles(g.putTokens(g.getRoles()));
                xml.add((Object)g.roleString);
                xml.add((Object)g.groupString);
                xml.add((Object)g.preferences);
                xml.add((Object)g.userInfo);
                xml.add((Object)g.rules);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSUser g = (JSUser)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", "unknown"));
                Object o1 = null;
                while (xml.hasNext()) {
                    o1 = xml.getNext();
                    if (o1 instanceof JSPWAttributes) {
                        g.pwData = (JSPWAttributes)o1;
                        g.resetPassword();
                        continue;
                    }
                    if (o1 instanceof JSUserGroups) {
                        g.groupString = (JSUserGroups)o1;
                        continue;
                    }
                    if (o1 instanceof JSUserRoles) {
                        g.roleString = (JSUserRoles)o1;
                        continue;
                    }
                    if (o1 instanceof JSUserAttributes) {
                        g.userInfo = (JSUserAttributes)o1;
                        continue;
                    }
                    if (o1 instanceof JSNVPElements) {
                        g.preferences = (JSNVPElements)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSPrincipalRules)) continue;
                    g.rules = (JSPrincipalRules)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public void addPublicCredential(Object o) {
        if (this.publicCredentials == null) {
            this.publicCredentials = new ArrayList();
        }
        this.publicCredentials.add(o);
    }

    public void addPrivateCredential(Object o) {
        if (this.privateCredentials == null) {
            this.privateCredentials = new ArrayList();
        }
        this.privateCredentials.add(o);
    }

    public void addGroup(JSGroup group) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        this.groups.add(group);
    }

    public void addRole(JSRole role) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        this.roles.add(role);
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public void setGroups(ArrayList groups) {
        this.groups = groups;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setUserCredential(String name, char[] password, Date expirationDate, boolean isEnabled, boolean isExpired, boolean requireUpdate) {
        this.setName(name);
        this.setPassword(password);
        this.pwData = new JSPWAttributes();
        if (password != null) {
            this.pwData.getMyMap().put("password", this.getPasswordString());
            if (expirationDate != null) {
                this.pwData.getMyMap().put("expirationDate", expirationDate.toString());
            }
            this.pwData.getMyMap().put("enabled", isEnabled ? "TRUE" : "FALSE");
            this.pwData.getMyMap().put("requiresUpdate", requireUpdate ? "TRUE" : "FALSE");
        }
    }

    protected void resetPassword() {
        try {
            if (this.pwData != null) {
                Object o = this.pwData.getMyMap().get("password");
                String pw = StringEscapeUtils.unescapeHtml((String)((String)o));
                this.password = (char[])(pw != null && pw.length() > 0 ? pw.toCharArray() : null);
            }
        }
        catch (Exception e) {
            this.password = null;
        }
    }

    public boolean getPwEnabled() {
        return this.getPWBoolean("enabled", false);
    }

    public boolean getPwRequiredUpdate() {
        return this.getPWBoolean("requiresUpdate", false);
    }

    public Date getPwExpirationDate() {
        if (this.pwData != null) {
            Object o = this.pwData.getMyMap().get("expirationDate");
            if (o == null) {
                return null;
            }
            if (o instanceof Date) {
                return (Date)o;
            }
            Date d = Date.valueOf((String)o);
            return d;
        }
        return null;
    }

    private boolean getPWBoolean(String property, boolean defaultSetting) {
        if (this.pwData == null) {
            return defaultSetting;
        }
        try {
            Object o = this.pwData.getMyMap().get(property);
            if (o == null) {
                return defaultSetting;
            }
            return ((String)o).equalsIgnoreCase("TRUE");
        }
        catch (Exception e) {
            return defaultSetting;
        }
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getRoles() {
        return this.roles;
    }

    public void setRoles(ArrayList roles) {
        this.roles = roles;
    }

    public String getName() {
        return this.name;
    }

    public JSNVPElements getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = new JSNVPElements(preferences);
    }

    public ArrayList getPrivateCredentials() {
        return this.privateCredentials;
    }

    public void setPrivateCredentials(ArrayList privateCredentials) {
        this.privateCredentials = privateCredentials;
    }

    public ArrayList getPublicCredentials() {
        return this.publicCredentials;
    }

    public void setPublicCredentials(ArrayList publicCredentials) {
        this.publicCredentials = publicCredentials;
    }

    public void setUserInfo(Preferences userInfo) {
        this.userInfo = new JSUserAttributes(userInfo);
    }

    public JSUserAttributes getUserInfo() {
        return this.userInfo;
    }

    private String append(JSRole rule) {
        return rule.getName();
    }

    private String append(JSGroup group) {
        return group.getName();
    }

    private String append(Object s) {
        if (s instanceof JSRole) {
            return this.append((JSRole)s);
        }
        if (s instanceof JSGroup) {
            return this.append((JSGroup)s);
        }
        return s.toString();
    }

    private String putTokens(ArrayList _list) {
        if (_list == null || _list.size() == 0) {
            return "";
        }
        boolean _start = true;
        Iterator _it = _list.iterator();
        StringBuffer _sb = new StringBuffer();
        while (_it.hasNext()) {
            if (!_start) {
                _sb.append(',');
            } else {
                _start = false;
            }
            _sb.append(this.append(_it.next()));
        }
        return _sb.toString();
    }

    private String getPasswordString() {
        if (this.getPassword() == null || this.getPassword().length == 0) {
            return "";
        }
        return new String(this.getPassword());
    }

    public JSPrincipalRules getRules() {
        return this.rules;
    }

    public void setRules(JSPrincipalRules rules) {
        this.rules = rules;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public JSUserGroups getGroupString() {
        return this.groupString;
    }

    public JSUserRoles getRoleString() {
        return this.roleString;
    }

    public JSPWAttributes getPwData() {
        return this.pwData;
    }

    public void setPwData(JSPWAttributes pwData) {
        this.pwData = pwData;
    }
}

