/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.ArrayList;
import java.util.Iterator;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.security.FolderPermission;
import org.apache.jetspeed.security.FragmentPermission;
import org.apache.jetspeed.security.PagePermission;
import org.apache.jetspeed.security.PortalResourcePermission;
import org.apache.jetspeed.security.PortletPermission;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.jetspeed.serializer.objects.JSRole;
import org.apache.jetspeed.serializer.objects.JSUser;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;
import org.apache.jetspeed.serializer.objects.JSUserUsers;

public class JSPermission {
    private String type;
    private String resource;
    private String actions;
    private long id;
    private ArrayList roles = null;
    private ArrayList groups = null;
    private ArrayList users = null;
    private JSUserRoles roleString;
    private JSUserGroups groupString;
    private JSUserUsers userString;
    public static final String TYPE_FOLDER = "folder".intern();
    public static final String TYPE_FRAGMENT = "fragment".intern();
    public static final String TYPE_PAGE = "page".intern();
    public static final String TYPE_PORTALRESOURCE = "portalResource".intern();
    public static final String TYPE_PORTALRESOURCECOLLECTION = "portalResource".intern();
    public static final String TYPE_PORTAL = "portal".intern();
    public static final String TYPE_UNKNOWN = "unknown".intern();
    private static final XMLFormat XML = new XMLFormat(JSPermission.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSPermission g = (JSPermission)o;
                xml.setAttribute("type", g.getType());
                xml.setAttribute("resource", g.getResource());
                xml.setAttribute("actions", g.getActions());
                g.groupString = new JSUserGroups(g.putTokens(g.getGroups()));
                g.roleString = new JSUserRoles(g.putTokens(g.getRoles()));
                g.userString = new JSUserUsers(g.putTokens(g.getUsers()));
                xml.add((Object)g.roleString);
                xml.add((Object)g.groupString);
                xml.add((Object)g.userString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSPermission g = (JSPermission)o;
                g.type = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("type", "type_unknown"));
                g.resource = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("resource", "resource_unknown"));
                g.actions = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("actions", "unknown_actions"));
                while (xml.hasNext()) {
                    Object o1 = xml.getNext();
                    if (o1 instanceof JSUserGroups) {
                        g.groupString = (JSUserGroups)o1;
                        continue;
                    }
                    if (o1 instanceof JSUserUsers) {
                        g.userString = (JSUserUsers)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSUserRoles)) continue;
                    g.roleString = (JSUserRoles)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public String getClassForType(String type) {
        if (type == null || type.length() == 0 || type.equals(TYPE_UNKNOWN)) {
            return "";
        }
        if (type.equals(TYPE_FOLDER)) {
            return "org.apache.jetspeed.security.FolderPermission";
        }
        if (type.equals(TYPE_FRAGMENT)) {
            return "org.apache.jetspeed.security.FragmentPermission";
        }
        if (type.equals(TYPE_PAGE)) {
            return "org.apache.jetspeed.security.PagePermission";
        }
        if (type.equals(TYPE_PORTALRESOURCE)) {
            return "org.apache.jetspeed.security.PortalResourcePermission";
        }
        if (type.equals(TYPE_PORTALRESOURCECOLLECTION)) {
            return "org.apache.jetspeed.security.PortalResourcePermissionCollection";
        }
        if (type.equals(TYPE_PORTAL)) {
            return "org.apache.jetspeed.security.PortletPermission";
        }
        return "";
    }

    public String getTypeForClass(String className) {
        if (className == null || className.length() == 0) {
            return TYPE_UNKNOWN;
        }
        if (className.equals("org.apache.jetspeed.security.FolderPermission")) {
            return TYPE_FOLDER;
        }
        if (className.equals("org.apache.jetspeed.security.FragmentPermission")) {
            return TYPE_FRAGMENT;
        }
        if (className.equals("org.apache.jetspeed.security.PagePermission")) {
            return TYPE_PAGE;
        }
        if (className.equals("org.apache.jetspeed.security.PortletPermission")) {
            return TYPE_PORTAL;
        }
        if (className.equals("org.apache.jetspeed.security.PortalResourcePermission")) {
            return TYPE_PORTALRESOURCE;
        }
        if (className.equals("org.apache.jetspeed.security.PortalResourcePermissionCollection")) {
            return TYPE_PORTALRESOURCECOLLECTION;
        }
        return TYPE_UNKNOWN;
    }

    public PortalResourcePermission getPermissionForType() {
        FolderPermission newPermission = null;
        if (this.type == null || this.type.equals(TYPE_UNKNOWN)) {
            return null;
        }
        try {
            if (this.type.equals(TYPE_FOLDER)) {
                newPermission = new FolderPermission(this.resource, this.actions);
            } else if (this.type.equals(TYPE_FRAGMENT)) {
                newPermission = new FragmentPermission(this.resource, this.actions);
            } else if (this.type.equals(TYPE_PAGE)) {
                newPermission = new PagePermission(this.resource, this.actions);
            } else if (this.type.equals(TYPE_PORTAL)) {
                newPermission = new PortletPermission(this.resource, this.actions);
            } else {
                return null;
            }
            return newPermission;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String append(JSRole rule) {
        return rule.getName();
    }

    private String append(JSGroup group) {
        return group.getName();
    }

    private String append(JSUser user) {
        return user.getName();
    }

    private String append(Object s) {
        if (s instanceof JSRole) {
            return this.append((JSRole)s);
        }
        if (s instanceof JSGroup) {
            return this.append((JSGroup)s);
        }
        if (s instanceof JSUser) {
            return this.append((JSUser)s);
        }
        return s.toString();
    }

    private String putTokens(ArrayList _list) {
        if (_list == null || _list.size() == 0) {
            return "";
        }
        boolean _start = true;
        Iterator _it = _list.iterator();
        StringBuffer _sb = new StringBuffer();
        while (_it.hasNext()) {
            if (!_start) {
                _sb.append(',');
            } else {
                _start = false;
            }
            _sb.append(this.append(_it.next()));
        }
        return _sb.toString();
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public void setGroups(ArrayList groups) {
        this.groups = groups;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ArrayList getRoles() {
        return this.roles;
    }

    public void setRoles(ArrayList roles) {
        this.roles = roles;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ArrayList getUsers() {
        return this.users;
    }

    public void setUsers(ArrayList users) {
        this.users = users;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void addGroup(JSGroup group) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        this.groups.add(group);
    }

    public void addRole(JSRole role) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        this.roles.add(role);
    }

    public void addUser(JSUser user) {
        if (this.users == null) {
            this.users = new ArrayList();
        }
        this.users.add(user);
    }

    public JSUserGroups getGroupString() {
        return this.groupString;
    }

    public JSUserRoles getRoleString() {
        return this.roleString;
    }

    public JSUserUsers getUserString() {
        return this.userString;
    }
}

