/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.components.jndi.SpringJNDIStarter;
import org.apache.jetspeed.serializer.JetspeedSerializer;
import org.apache.jetspeed.serializer.JetspeedSerializerBase;
import org.apache.jetspeed.serializer.JetspeedSerializerFactory;
import org.apache.jetspeed.serializer.JetspeedSerializerImpl;
import org.apache.jetspeed.serializer.JetspeedSerializerSecondaryImpl;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JetspeedSerializerApplication
implements JetspeedSerializerFactory {
    public static final String JNDI_DS_NAME = "jetspeed";

    public JetspeedSerializer create(String serializerType) {
        if (serializerType.equals("secondary")) {
            return new JetspeedSerializerSecondaryImpl();
        }
        return new JetspeedSerializerImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String propertyFileName = null;
        String fileName = null;
        String applicationPath = null;
        String bootConfigFiles = null;
        String configFiles = null;
        String name = null;
        String options = null;
        PropertiesConfiguration configuration = null;
        String defaultIndent = null;
        String driverClass = null;
        String url = null;
        String user = null;
        String password = null;
        String logLevel = null;
        boolean doImport = false;
        boolean doExport = false;
        if (args == null) {
            throw new IllegalArgumentException("Either import or export have to be defined (-I or -E follwoed by the filename");
        }
        for (int n = 0; n < args.length; ++n) {
            if (args[n].equals("-p")) {
                propertyFileName = args[++n];
                continue;
            }
            if (args[n].equals("-a")) {
                applicationPath = args[++n];
                continue;
            }
            if (args[n].equals("-b")) {
                bootConfigFiles = args[++n];
                continue;
            }
            if (args[n].equals("-c")) {
                configFiles = args[++n];
                continue;
            }
            if (args[n].equals("-E")) {
                doExport = true;
                fileName = args[++n];
                continue;
            }
            if (args[n].equals("-I")) {
                doImport = true;
                fileName = args[++n];
                continue;
            }
            if (args[n].equals("-N")) {
                name = args[++n];
                continue;
            }
            if (args[n].equals("-l")) {
                logLevel = args[++n];
                continue;
            }
            if (args[n].equals("-O")) {
                options = args[++n];
                continue;
            }
            if (args[n].equals("-dc")) {
                driverClass = args[++n];
                continue;
            }
            if (args[n].equals("-ds")) {
                url = args[++n];
                continue;
            }
            if (args[n].equals("-du")) {
                if (n + 1 >= args.length || args[n + 1].startsWith("-d")) {
                    user = "";
                    continue;
                }
                user = args[++n];
                continue;
            }
            if (args[n].equals("-dp")) {
                if (n + 1 >= args.length || args[n + 1].startsWith("-d")) {
                    password = "";
                    continue;
                }
                password = args[++n];
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + args[n]);
        }
        if (!doImport && !doExport) {
            throw new IllegalArgumentException("Either import or export have to be defined (-I or -E follwoed by the filename");
        }
        if (doImport && doExport) {
            throw new IllegalArgumentException("Only one - either import or export - can be requested");
        }
        if (name == null) {
            name = fileName;
        }
        if (propertyFileName == null) {
            propertyFileName = System.getProperty("org.apache.jetspeed.xml.importer.configuration", null);
        }
        if (propertyFileName != null) {
            try {
                configuration = new PropertiesConfiguration(propertyFileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (configuration != null) {
                if (applicationPath == null) {
                    applicationPath = configuration.getString("applicationPath");
                }
                if (bootConfigFiles == null) {
                    bootConfigFiles = configuration.getString("bootConfigFiles");
                }
                if (configFiles == null) {
                    configFiles = configuration.getString("configFiles");
                }
                if (options == null) {
                    options = configuration.getString("options");
                }
                if (defaultIndent == null) {
                    defaultIndent = configuration.getString("defaultIndent");
                }
                if (driverClass == null) {
                    driverClass = configuration.getString("driverClass");
                }
                if (url == null) {
                    url = configuration.getString("url");
                }
                if (user == null) {
                    user = configuration.getString("user");
                }
                if (password == null) {
                    password = configuration.getString("password");
                }
                if (logLevel == null) {
                    logLevel = configuration.getString("loglevel");
                }
            }
        }
        if (applicationPath == null) {
            applicationPath = "./";
        }
        if (bootConfigFiles == null) {
            bootConfigFiles = "assembly/boot/";
        }
        if (configFiles == null) {
            configFiles = "assembly/";
        }
        if (logLevel == null) {
            logLevel = "ERROR";
        }
        bootConfigFiles = bootConfigFiles + "*.xml";
        configFiles = configFiles + "*.xml";
        HashMap<String, Boolean> settings = null;
        int processHelper = 1;
        if (options != null) {
            settings = new HashMap<String, Boolean>();
            settings.put(JetspeedSerializer.KEY_PROCESS_USERS, Boolean.FALSE);
            settings.put(JetspeedSerializer.KEY_PROCESS_CAPABILITIES, Boolean.FALSE);
            settings.put(JetspeedSerializer.KEY_PROCESS_PROFILER, Boolean.FALSE);
            settings.put(JetspeedSerializer.KEY_PROCESS_USER_PREFERENCES, Boolean.FALSE);
            settings.put(JetspeedSerializer.KEY_PROCESS_SSO, Boolean.FALSE);
            settings.put(JetspeedSerializer.KEY_OVERWRITE_EXISTING, Boolean.TRUE);
            settings.put(JetspeedSerializer.KEY_BACKUP_BEFORE_PROCESS, Boolean.FALSE);
            String[] optionSet = JetspeedSerializerApplication.getTokens(options);
            processHelper = 0;
            for (int i = 0; i < optionSet.length; ++i) {
                String o = optionSet[i];
                if (o.equalsIgnoreCase("all")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_USERS, Boolean.TRUE);
                    settings.put(JetspeedSerializer.KEY_PROCESS_CAPABILITIES, Boolean.TRUE);
                    settings.put(JetspeedSerializer.KEY_PROCESS_PROFILER, Boolean.TRUE);
                    settings.put(JetspeedSerializer.KEY_PROCESS_PERMISSIONS, Boolean.TRUE);
                    settings.put(JetspeedSerializer.KEY_PROCESS_SSO, Boolean.TRUE);
                    settings.put(JetspeedSerializer.KEY_PROCESS_USER_PREFERENCES, Boolean.FALSE);
                    processHelper = 1;
                    continue;
                }
                if (o.equalsIgnoreCase("user")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_USERS, Boolean.TRUE);
                    processHelper = 1;
                    continue;
                }
                if (o.equalsIgnoreCase("PREFS")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_USER_PREFERENCES, Boolean.TRUE);
                    processHelper = 2;
                    continue;
                }
                if (o.equalsIgnoreCase("CAPABILITIES")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_CAPABILITIES, Boolean.TRUE);
                    processHelper = 1;
                    continue;
                }
                if (o.equalsIgnoreCase("PROFILE")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_PROFILER, Boolean.TRUE);
                    processHelper = 1;
                    continue;
                }
                if (o.equalsIgnoreCase("PERMISSIONS")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_PERMISSIONS, Boolean.TRUE);
                    processHelper = 1;
                    continue;
                }
                if (o.equalsIgnoreCase("SSO")) {
                    settings.put(JetspeedSerializer.KEY_PROCESS_SSO, Boolean.TRUE);
                    processHelper = 1;
                    continue;
                }
                if (o.equalsIgnoreCase("NOOVERWRITE")) {
                    settings.put(JetspeedSerializer.KEY_OVERWRITE_EXISTING, Boolean.FALSE);
                    continue;
                }
                if (!o.equalsIgnoreCase("BACKUP")) continue;
                settings.put(JetspeedSerializer.KEY_BACKUP_BEFORE_PROCESS, Boolean.TRUE);
            }
        }
        JetspeedSerializerBase serializer = null;
        if (driverClass == null) {
            driverClass = System.getProperty("org.apache.jetspeed.database.driverClass", "com.mysql.jdbc.Driver");
        }
        if (url == null) {
            url = System.getProperty("org.apache.jetspeed.database.url", "jdbc:mysql://localhost/j2test");
        }
        if (user == null) {
            user = System.getProperty("org.apache.jetspeed.database.user", "user");
        }
        if (password == null) {
            password = System.getProperty("org.apache.jetspeed.database.password", "password");
        }
        if (driverClass == null) {
            throw new IllegalArgumentException("Can't proceed without a valid driver");
        }
        if (url == null) {
            throw new IllegalArgumentException("Can't proceed without a valid url to the target database");
        }
        if (user == null) {
            throw new IllegalArgumentException("Can't proceed without a valid database user");
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(SpringJNDIStarter.DATASOURCE_DRIVER, driverClass);
        context.put(SpringJNDIStarter.DATASOURCE_URL, url);
        context.put(SpringJNDIStarter.DATASOURCE_USERNAME, user);
        context.put(SpringJNDIStarter.DATASOURCE_PASSWORD, password);
        Logger logger = Logger.getLogger((String)"org.springframework");
        Level level = logger.getLevel();
        if (logLevel.equalsIgnoreCase("INFO")) {
            logger.setLevel(Level.INFO);
        } else if (logLevel.equalsIgnoreCase("WARN")) {
            logger.setLevel(Level.WARN);
        } else {
            logger.setLevel(Level.ERROR);
        }
        System.out.println("APP ROOT is " + applicationPath);
        System.setProperty("applicationRoot", applicationPath);
        System.setProperty("portal.name", "jetspped");
        SpringJNDIStarter starter = new SpringJNDIStarter(context, applicationPath, JetspeedSerializerApplication.getTokens(bootConfigFiles), JetspeedSerializerApplication.getTokens(configFiles));
        System.out.println("starter framework created " + starter);
        try {
            starter.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("starter framework established " + starter);
        String[] importList = null;
        if (doImport) {
            importList = JetspeedSerializerApplication.parseFiles(fileName);
        }
        if (doImport && importList != null && importList.length > 0) {
            for (int i = 0; i < importList.length; ++i) {
                try {
                    System.out.println("processing import  " + importList[i]);
                    serializer = processHelper == 2 ? new JetspeedSerializerSecondaryImpl((ComponentManager)starter.getComponentManager()) : new JetspeedSerializerImpl((ComponentManager)starter.getComponentManager());
                    serializer.importData(importList[i], settings);
                    System.out.println("processing import  " + importList[i] + " done");
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Failed to process XML import for " + importList[i] + ":" + e);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (serializer != null) {
                        serializer.closeUp();
                    }
                }
            }
        }
        if (doExport) {
            try {
                System.out.println("processing export to  " + fileName);
                serializer = processHelper == 2 ? new JetspeedSerializerSecondaryImpl((ComponentManager)starter.getComponentManager()) : new JetspeedSerializerImpl((ComponentManager)starter.getComponentManager());
                serializer.exportData(name, fileName, settings);
            }
            catch (Exception e) {
                System.err.println("Failed to process XML export of " + fileName + ": " + e);
                e.printStackTrace();
            }
            finally {
                if (serializer != null) {
                    serializer.closeUp();
                }
            }
        }
        try {
            starter.tearDown();
            logger.setLevel(level);
        }
        catch (Exception e1) {
            System.out.println("starter framework teardown caused exception " + e1.getLocalizedMessage());
            e1.printStackTrace();
        }
        System.out.println("DONE performing " + (doExport ? "export" : "import") + " with " + fileName);
    }

    private static String[] parseFiles(String schemaDirectory) {
        String[] fileList = null;
        try {
            File dir = new File(schemaDirectory);
            if (!dir.exists()) {
                return fileList;
            }
            if (!dir.isDirectory()) {
                fileList = new String[]{schemaDirectory};
                return fileList;
            }
            File[] files = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    String n = name.toLowerCase();
                    return n.endsWith("seed.xml");
                }
            });
            if (files == null) {
                return fileList;
            }
            fileList = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileList[i] = files[i].getAbsolutePath();
            }
            return fileList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Processing the schema-directory " + schemaDirectory + " caused exception " + e.getLocalizedMessage());
        }
    }

    private static String[] getTokens(String _line) {
        if (_line == null || _line.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(_line, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] s = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            s[i] = (String)list.get(i);
        }
        return s;
    }
}

