/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Permission;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.BaseJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.JetspeedPermissionFactory;

public class FolderPermission
extends BaseJetspeedPermission {
    private static final long serialVersionUID = -4005330590344182308L;
    public static final char RECURSIVE_CHAR = '-';
    public static final char WILD_CHAR = '*';
    public static final String WILD_CHAR_STR = new String(new char[]{'*'});
    public static final char FOLDER_SEPARATOR = '/';
    public static final String FOLDER_SEPARATOR_STR = new String(new char[]{'/'});
    private boolean folder;
    private boolean recursive;
    private String cpath;

    protected FolderPermission(PersistentJetspeedPermission permission) {
        super(permission);
        this.parsePath();
    }

    protected FolderPermission(String type, String name, int mask) {
        super(type, name, mask);
        this.parsePath();
    }

    protected FolderPermission(String type, String name, String actions) {
        super(type, name, actions);
        this.parsePath();
    }

    private void parsePath() {
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.folder = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int len = this.cpath.length();
        if (len == 0) {
            throw new IllegalArgumentException("invalid folder reference");
        }
        char last = this.cpath.charAt(len - 1);
        if (last == '-' && (len == 1 || this.cpath.charAt(len - 2) == '/')) {
            this.folder = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == '*' && (len == 1 || this.cpath.charAt(len - 2) == '/')) {
            this.folder = true;
            this.cpath = this.cpath.substring(0, --len);
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof FolderPermission)) {
            return false;
        }
        FolderPermission that = (FolderPermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(FolderPermission that) {
        if (this.folder) {
            if (this.recursive) {
                if (that.folder) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.folder) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(47);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        return this.cpath.equals(that.cpath);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FolderPermission)) {
            return false;
        }
        FolderPermission that = (FolderPermission)obj;
        return this.mask == that.mask && this.cpath.equals(that.cpath) && this.folder == that.folder && this.recursive == that.recursive;
    }

    @Override
    public int hashCode() {
        return this.cpath.hashCode();
    }

    public static class Factory
    extends JetspeedPermissionFactory {
        public Factory() {
            super("folder");
        }

        @Override
        public FolderPermission newPermission(String name, String actions) {
            return new FolderPermission(this.getType(), name, actions);
        }

        @Override
        public FolderPermission newPermission(String name, int mask) {
            return new FolderPermission(this.getType(), name, mask);
        }

        @Override
        public FolderPermission newPermission(PersistentJetspeedPermission permission) {
            if (permission.getType().equals(this.getType())) {
                return new FolderPermission(permission);
            }
            throw new IllegalArgumentException("Permission is not of type " + this.getType());
        }
    }
}

