/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Permission;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.BaseJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.JetspeedPermissionFactory;

public class PagePermission
extends BaseJetspeedPermission {
    private static final long serialVersionUID = -3374203894346164388L;

    protected PagePermission(PersistentJetspeedPermission permission) {
        super(permission);
    }

    protected PagePermission(String type, String name, int mask) {
        super(type, name, mask);
    }

    protected PagePermission(String type, String name, String actions) {
        super(type, name, actions);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PagePermission)) {
            return false;
        }
        if (!permission.getName().equals(this.getName())) {
            return false;
        }
        PagePermission pagePerm = (PagePermission)permission;
        return (this.mask & pagePerm.mask) == pagePerm.mask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PagePermission)) {
            return false;
        }
        PagePermission p = (PagePermission)object;
        return p.mask == this.mask && p.getName().equals(this.getName());
    }

    public static class Factory
    extends JetspeedPermissionFactory {
        public Factory() {
            super("page");
        }

        public PagePermission newPermission(String name, String actions) {
            return new PagePermission(this.getType(), name, actions);
        }

        public PagePermission newPermission(String name, int mask) {
            return new PagePermission(this.getType(), name, mask);
        }

        public PagePermission newPermission(PersistentJetspeedPermission permission) {
            if (permission.getType().equals(this.getType())) {
                return new PagePermission(permission);
            }
            throw new IllegalArgumentException("Permission is not of type " + this.getType());
        }
    }
}

