/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao.impl;

import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.jetspeed.security.mapping.SearchResultCallbackHandler;
import org.springframework.ldap.control.PagedResultsCookie;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;
import org.springframework.ldap.support.LdapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedSearchExecutor
implements SearchExecutor,
NameClassPairCallbackHandler {
    private static final NamingEnumeration<SearchResult> noResultsEnumeration = new NamingEnumeration<SearchResult>(){

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return false;
        }

        @Override
        public SearchResult next() throws NamingException {
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public SearchResult nextElement() {
            return null;
        }
    };
    private String base;
    private Name baseName;
    private String filter;
    private SearchControls controls;
    private SearchResultCallbackHandler handler;
    private int pageSize;

    protected PagedSearchExecutor(String filter, SearchControls controls, SearchResultCallbackHandler handler, int pageSize) {
        this.filter = filter;
        this.controls = controls;
        this.handler = handler;
        this.pageSize = pageSize;
    }

    public PagedSearchExecutor(String base, String filter, SearchControls controls, SearchResultCallbackHandler handler) {
        this(base, filter, controls, handler, -1);
    }

    public PagedSearchExecutor(Name baseName, String filter, SearchControls controls, SearchResultCallbackHandler handler) {
        this(baseName, filter, controls, handler, -1);
    }

    public PagedSearchExecutor(String base, String filter, SearchControls controls, SearchResultCallbackHandler handler, int pageSize) {
        this(filter, controls, handler, pageSize);
        this.base = base;
    }

    public PagedSearchExecutor(Name baseName, String filter, SearchControls controls, SearchResultCallbackHandler handler, int pageSize) {
        this(filter, controls, handler, pageSize);
        this.baseName = baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration<SearchResult> executeSearch(DirContext ctx) throws NamingException {
        NamingEnumeration<SearchResult> results = null;
        PagedResultsDirContextProcessor processor = null;
        boolean noExceptions = false;
        try {
            int pageSize;
            PagedResultsCookie cookie = null;
            int index = 0;
            boolean doNext = true;
            if (this.handler.getMaxCount() > 0 && this.controls.getCountLimit() <= 0L || (long)(this.handler.getMaxCount() + 1) < this.controls.getCountLimit()) {
                this.controls.setCountLimit(this.handler.getMaxCount() + 1);
            }
            int n = pageSize = this.handler.getSearchPageSize() < 0 ? this.pageSize : this.handler.getSearchPageSize();
            if (pageSize > 0) {
                do {
                    processor = new PagedResultsDirContextProcessor(pageSize, cookie);
                    processor.preProcess(ctx);
                    results = this.base != null ? ctx.search(this.base, this.filter, this.controls) : ctx.search(this.baseName, this.filter, this.controls);
                    int pageIndex = 0;
                    while (doNext && results.hasMore()) {
                        doNext = this.handler.handleSearchResult(results.next(), pageSize, pageIndex++, index++);
                    }
                    processor.postProcess(ctx);
                    cookie = processor.getCookie();
                } while (doNext && cookie != null && cookie.getCookie() != null && cookie.getCookie().length != 0);
            } else {
                results = this.base != null ? ctx.search(this.base, this.filter, this.controls) : ctx.search(this.baseName, this.filter, this.controls);
                int pageIndex = 0;
                while (doNext && results.hasMore()) {
                    doNext = this.handler.handleSearchResult(results.next(), pageSize, pageIndex++, index++);
                }
            }
            noExceptions = true;
        }
        finally {
            block20: {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception e) {}
                }
                if (processor != null) {
                    try {
                        LdapContext ldapContext = (LdapContext)ctx;
                        ldapContext.setRequestControls(null);
                        processor.postProcess(ctx);
                    }
                    catch (NamingException e) {
                        if (!noExceptions) break block20;
                        throw LdapUtils.convertLdapException((NamingException)e);
                    }
                }
            }
        }
        return noResultsEnumeration;
    }

    public void handleNameClassPair(NameClassPair nameClassPair) {
    }
}

