/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.CredentialPasswordValidator;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.AlgorithmUpgradeCredentialPasswordEncoder;
import org.apache.jetspeed.security.spi.PasswordCredentialInterceptor;
import org.apache.jetspeed.security.spi.UserPasswordCredentialPolicyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPasswordCredentialPolicyManagerImpl
implements UserPasswordCredentialPolicyManager {
    private CredentialPasswordEncoder encoder;
    private CredentialPasswordValidator validator;
    private PasswordCredentialInterceptor[] interceptors;

    public UserPasswordCredentialPolicyManagerImpl() {
        this.interceptors = new PasswordCredentialInterceptor[0];
    }

    public UserPasswordCredentialPolicyManagerImpl(CredentialPasswordEncoder encoder, CredentialPasswordValidator validator, List<?> interceptors) {
        this.encoder = encoder;
        this.validator = validator;
        this.interceptors = interceptors != null ? interceptors.toArray(new PasswordCredentialInterceptor[interceptors.size()]) : new PasswordCredentialInterceptor[0];
    }

    @Override
    public CredentialPasswordEncoder getCredentialPasswordEncoder() {
        return this.encoder;
    }

    @Override
    public CredentialPasswordValidator getCredentialPasswordValidator() {
        return this.validator;
    }

    @Override
    public boolean onLoad(PasswordCredential credential, String userName) throws SecurityException {
        boolean update = false;
        for (PasswordCredentialInterceptor pci : this.interceptors) {
            if (!pci.afterLoad(userName, credential, this.encoder, this.validator)) continue;
            update = true;
        }
        return update;
    }

    @Override
    public boolean authenticate(PasswordCredential credential, String userName, String password) throws SecurityException {
        return this.authenticate(credential, userName, password, false);
    }

    @Override
    public boolean authenticate(PasswordCredential credential, String userName, String password, boolean authenticated) throws SecurityException {
        if (!authenticated) {
            String encodedPassword = password;
            if (this.encoder != null && credential.isEncoded()) {
                encodedPassword = this.encoder instanceof AlgorithmUpgradeCredentialPasswordEncoder ? ((AlgorithmUpgradeCredentialPasswordEncoder)this.encoder).encode(credential, password) : this.encoder.encode(userName, password);
                authenticated = credential.getPassword().equals(encodedPassword);
            }
        }
        boolean update = false;
        for (PasswordCredentialInterceptor pci : this.interceptors) {
            if (!pci.afterAuthenticated(credential, authenticated)) continue;
            update = true;
        }
        if (update && (!credential.isEnabled() || credential.isExpired())) {
            authenticated = false;
        }
        if (authenticated) {
            credential.setAuthenticationFailures(0);
            if (this.encoder != null && this.encoder instanceof AlgorithmUpgradeCredentialPasswordEncoder) {
                ((AlgorithmUpgradeCredentialPasswordEncoder)this.encoder).recodeIfNeeded(credential, password);
                credential.clearNewPasswordSet();
            }
            credential.setPreviousAuthenticationDate(credential.getLastAuthenticationDate());
            credential.setLastAuthenticationDate(new Timestamp(new Date().getTime()));
            update = true;
        } else {
            credential.setAuthenticationFailures(credential.getAuthenticationFailures() + 1);
        }
        return update;
    }

    @Override
    public void onStore(PasswordCredential credential) throws SecurityException {
        this.onStore(credential, false);
    }

    @Override
    public void onStore(PasswordCredential credential, boolean authenticated) throws SecurityException {
        if (credential.isNewPasswordSet()) {
            String newPassword = null;
            if (credential.getNewPassword() != null) {
                if (credential.getOldPassword() != null && !authenticated) {
                    String validatingOldPassword = credential.getOldPassword();
                    if (credential.isEncoded() && this.encoder != null) {
                        validatingOldPassword = this.encoder instanceof AlgorithmUpgradeCredentialPasswordEncoder ? ((AlgorithmUpgradeCredentialPasswordEncoder)this.encoder).encode(credential, validatingOldPassword) : this.encoder.encode(credential.getUserName(), validatingOldPassword);
                    }
                    if (credential.getPassword() == null || !credential.getPassword().equals(validatingOldPassword)) {
                        throw new InvalidPasswordException();
                    }
                    authenticated = true;
                }
                if (this.validator != null) {
                    this.validator.validate(credential.getNewPassword());
                }
                newPassword = credential.getNewPassword();
                if (this.encoder != null) {
                    newPassword = this.encoder.encode(credential.getUserName(), newPassword);
                }
            } else {
                newPassword = credential.getPassword();
                if (this.encoder != null && !credential.isEncoded()) {
                    newPassword = this.encoder.encode(credential.getUserName(), newPassword);
                }
            }
            if (!credential.isNew()) {
                for (PasswordCredentialInterceptor pci : this.interceptors) {
                    pci.beforeSetPassword(credential, newPassword, authenticated);
                }
                credential.setUpdateRequired(false);
            }
            credential.setPassword(newPassword, this.encoder != null);
            credential.clearNewPasswordSet();
            if (!authenticated) {
                if (this.encoder != null && this.encoder instanceof AlgorithmUpgradeCredentialPasswordEncoder) {
                    credential.setPreviousAuthenticationDate(new Timestamp(new Date().getTime()));
                    credential.setLastAuthenticationDate(null);
                }
            } else {
                credential.setPreviousAuthenticationDate(credential.getLastAuthenticationDate());
                credential.setLastAuthenticationDate(new Timestamp(new Date().getTime()));
            }
        }
        if (credential.isNew()) {
            for (PasswordCredentialInterceptor pci : this.interceptors) {
                pci.beforeCreate(credential);
            }
        }
    }
}

