/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.List;
import java.util.Map;
import org.apache.jetspeed.security.spi.JetspeedPrincipalLookupManager;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPrincipalLookupManagerFactory {
    static final Logger log = LoggerFactory.getLogger(JetspeedPrincipalLookupManagerFactory.class);
    private static JetspeedPrincipalLookupManager jppm = null;
    private Map<String, JetspeedPrincipalLookupManager> mappings = null;

    public void setMappings(Map<String, JetspeedPrincipalLookupManager> mappings) {
        this.mappings = mappings;
    }

    public JetspeedPrincipalLookupManager getJetspeedPrincipalLookupManager() {
        if (jppm == null) {
            String platform = null;
            ConnectionRepository cr = MetadataManager.getInstance().connectionRepository();
            List jcdList = cr.getAllDescriptor();
            for (int i = 0; i < jcdList.size(); ++i) {
                if (platform == null) {
                    platform = ((JdbcConnectionDescriptor)jcdList.get(i)).getDbms();
                    continue;
                }
                if (platform.equals(((JdbcConnectionDescriptor)jcdList.get(i)).getDbms())) continue;
                if (log.isInfoEnabled()) {
                    log.info("Found more than one JdbcConnectionDescriptor. Not sure which one to take, so using compatible default behavior.");
                }
                platform = null;
                break;
            }
            for (Map.Entry<String, JetspeedPrincipalLookupManager> e : this.mappings.entrySet()) {
                if (!e.getKey().equalsIgnoreCase(platform)) continue;
                jppm = e.getValue();
                break;
            }
            if (jppm == null) {
                jppm = this.mappings.get("default");
            }
        }
        return jppm;
    }
}

