/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticatedUserImpl;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalQueryContext;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.JetspeedSubjectFactory;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.PrincipalsSet;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserResultList;
import org.apache.jetspeed.security.impl.BaseJetspeedPrincipalManager;
import org.apache.jetspeed.security.impl.TransientUser;
import org.apache.jetspeed.security.impl.UserCredentialImpl;
import org.apache.jetspeed.security.impl.UserImpl;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialManager;
import org.apache.jetspeed.security.spi.UserSubjectPrincipalsProvider;
import org.apache.jetspeed.security.spi.UserSubjectPrincipalsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagerImpl
extends BaseJetspeedPrincipalManager
implements UserManager,
UserSubjectPrincipalsProvider {
    private static final long serialVersionUID = 2811398259474293885L;
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private String anonymousUser = "guest";
    private JetspeedPrincipalType roleType;
    private JetspeedPrincipalType groupType;
    private UserPasswordCredentialManager credentialManager;
    private RoleManager roleManager;
    private GroupManager groupManager;
    private Map<String, UserSubjectPrincipalsResolver> usprMap = new HashMap<String, UserSubjectPrincipalsResolver>();

    public UserManagerImpl(JetspeedPrincipalType principalType, JetspeedPrincipalType roleType, JetspeedPrincipalType groupType, JetspeedPrincipalAccessManager jpam, JetspeedPrincipalStorageManager jpsm, UserPasswordCredentialManager credentialManager) {
        super(principalType, jpam, jpsm);
        this.credentialManager = credentialManager;
        this.roleType = roleType;
        this.groupType = groupType;
    }

    public void checkInitialized() {
        if (this.groupManager == null) {
            this.groupManager = (GroupManager)this.getPrincipalManagerProvider().getManager(this.groupType);
        }
        if (this.roleManager == null) {
            this.roleManager = (RoleManager)this.getPrincipalManagerProvider().getManager(this.roleType);
        }
    }

    public User addUser(String username) throws SecurityException {
        return this.addUser(username, true);
    }

    public User addUser(String username, boolean mapped) throws SecurityException {
        User user = this.newUser(username, mapped);
        super.addPrincipal((JetspeedPrincipal)user, null);
        if (log.isDebugEnabled()) {
            log.debug("Added user: " + username);
        }
        return user;
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public PasswordCredential getPasswordCredential(User user) throws SecurityException {
        if (this.credentialManager != null) {
            return this.credentialManager.getPasswordCredential(user);
        }
        return null;
    }

    public Subject getSubject(User user) throws SecurityException {
        PasswordCredential pwc;
        if (!this.getAnonymousUser().equals(user.getName()) && this.credentialManager != null && (pwc = this.getPasswordCredential(user)) != null) {
            UserCredentialImpl credential = new UserCredentialImpl((UserCredential)pwc);
            HashSet<UserCredentialImpl> privateCred = new HashSet<UserCredentialImpl>();
            privateCred.add(credential);
            return this.getSubject((AuthenticatedUser)new AuthenticatedUserImpl(user, null, privateCred));
        }
        return this.getSubject((AuthenticatedUser)new AuthenticatedUserImpl(user, null, null));
    }

    public Subject getSubject(AuthenticatedUser user) throws SecurityException {
        PrincipalsSet principals = new PrincipalsSet();
        this.resolveSubjectPrincipals(user, (Set<Principal>)principals);
        return JetspeedSubjectFactory.createSubject((User)user.getUser(), this.getPublicCredentialsForSubject(user), this.getPrivateCredentialsForSubject(user), (Set)principals);
    }

    protected Set<Object> getPublicCredentialsForSubject(AuthenticatedUser user) {
        HashSet<Object> credentials = new HashSet<Object>();
        if (user.getPublicCredentials() != null) {
            credentials.addAll(user.getPublicCredentials());
        }
        return credentials;
    }

    protected Set<Object> getPrivateCredentialsForSubject(AuthenticatedUser user) {
        HashSet<Object> credentials = new HashSet<Object>();
        if (user.getPrivateCredentials() != null) {
            credentials.addAll(user.getPrivateCredentials());
        }
        return credentials;
    }

    protected void resolveSubjectPrincipals(AuthenticatedUser user, Set<Principal> principals) throws SecurityException {
        this.checkInitialized();
        HashSet<Long> resolvedIds = new HashSet<Long>();
        for (UserSubjectPrincipalsResolver resolver : this.usprMap.values()) {
            resolver.resolve(user.getUser(), resolvedIds, principals, this.usprMap);
        }
    }

    public User getUser(String username) throws SecurityException {
        User user = (User)this.getPrincipal(username);
        if (null == user) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)username));
        }
        return user;
    }

    public List<String> getUserNames(String nameFilter) throws SecurityException {
        return this.getPrincipalNames(nameFilter);
    }

    public List<User> getUsers(String nameFilter) throws SecurityException {
        return this.getPrincipals(nameFilter);
    }

    public UserResultList getUsersExtended(JetspeedPrincipalQueryContext queryContext) throws SecurityException {
        return new UserResultList(this.getPrincipals(queryContext));
    }

    public List<User> getUsersInGroup(String groupFullPathName) throws SecurityException {
        return super.getAssociatedTo(groupFullPathName, this.groupType, "isMemberOf");
    }

    public List<User> getUsersInRole(String roleFullPathName) throws SecurityException {
        return super.getAssociatedTo(roleFullPathName, this.roleType, "isMemberOf");
    }

    public List<User> lookupUsers(String attributeName, String attributeValue) throws SecurityException {
        return super.getPrincipalsByAttribute(attributeName, attributeValue);
    }

    public User newTransientUser(String name) {
        TransientUser user = new TransientUser(name);
        return user;
    }

    public User newUser(String name) {
        UserImpl user = new UserImpl(name);
        return user;
    }

    public User newUser(String name, boolean mapped) {
        UserImpl user = new UserImpl(name);
        user.setMapped(mapped);
        return user;
    }

    public void removeUser(String username) throws SecurityException {
        User user = this.getUser(username);
        super.removePrincipal((JetspeedPrincipal)user);
    }

    public void storePasswordCredential(PasswordCredential credential) throws SecurityException {
        if (this.credentialManager == null) {
            throw new UnsupportedOperationException();
        }
        this.credentialManager.storePasswordCredential(credential);
    }

    public void updateUser(User user) throws SecurityException {
        super.updatePrincipal((JetspeedPrincipal)user);
    }

    public boolean userExists(String username) {
        return super.principalExists(username);
    }

    public JetspeedPrincipal newPrincipal(String name, boolean mapped) {
        return this.newUser(name, mapped);
    }

    public JetspeedPrincipal newTransientPrincipal(String name) {
        return this.newTransientUser(name);
    }

    @Override
    public void addSubjectPrincipalsResolver(UserSubjectPrincipalsResolver resolver) {
        this.usprMap.put(resolver.getPrincipalType().getName(), resolver);
    }
}

