/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.ldap.dao.LDAPEntityDAOConfiguration;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.mapping.model.impl.AttributeImpl;
import org.apache.jetspeed.security.mapping.model.impl.EntityImpl;
import org.springframework.ldap.support.LdapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityFactoryImpl
implements EntityFactory {
    LDAPEntityDAOConfiguration searchConfiguration;

    public EntityFactoryImpl(LDAPEntityDAOConfiguration searchConfiguration) {
        this.searchConfiguration = searchConfiguration;
    }

    protected EntityImpl internalCreateEntity(String entityId, String internalId, Set<org.apache.jetspeed.security.mapping.model.Attribute> attributes) {
        EntityImpl entity = new EntityImpl(this.searchConfiguration.getEntityType(), entityId, this.searchConfiguration.getAttributeDefinitions());
        entity.setAttributes(attributes);
        if (internalId != null) {
            entity.setInternalId(internalId);
        }
        entity.setType(this.searchConfiguration.getEntityType());
        return entity;
    }

    @Override
    public Entity createEntity(JetspeedPrincipal principal) {
        HashSet<org.apache.jetspeed.security.mapping.model.Attribute> ldapAttrValues = new HashSet<org.apache.jetspeed.security.mapping.model.Attribute>();
        SecurityAttributes sas = principal.getSecurityAttributes();
        for (AttributeDef attrDef : this.searchConfiguration.getAttributeDefinitions()) {
            SecurityAttribute sa = sas.getAttribute(attrDef.getMappedName());
            if (sa == null) continue;
            AttributeImpl attr = new AttributeImpl(attrDef);
            attr.setValue(sa.getStringValue());
            ldapAttrValues.add(attr);
        }
        return this.internalCreateEntity(principal.getName(), null, ldapAttrValues);
    }

    public String[] getStringAttributes(Attributes originalAttrs, String name) {
        String[] attributes;
        Attribute attribute = originalAttrs.get(name);
        if (attribute != null && attribute.size() > 0) {
            attributes = new String[attribute.size()];
            for (int i = 0; i < attribute.size(); ++i) {
                try {
                    attributes[i] = (String)attribute.get(i);
                    continue;
                }
                catch (NamingException e) {
                    throw LdapUtils.convertLdapException((NamingException)e);
                }
            }
        } else {
            return null;
        }
        return attributes;
    }

    @Override
    public Entity createEntity(DirContext ctx) {
        String entityId = null;
        EntityImpl entity = null;
        HashSet<org.apache.jetspeed.security.mapping.model.Attribute> attributes = new HashSet<org.apache.jetspeed.security.mapping.model.Attribute>();
        for (AttributeDef attrDef : this.searchConfiguration.getAttributeDefinitions()) {
            String[] values = null;
            try {
                values = this.getStringAttributes(ctx.getAttributes(""), attrDef.getName());
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            if (values == null || values.length <= 0) continue;
            AttributeImpl a = new AttributeImpl(attrDef);
            if (attrDef.isMultiValue()) {
                ArrayList<String> attrValues = new ArrayList<String>();
                attrValues.addAll(Arrays.asList(values));
                if (attrDef.isRequired() && attrDef.getRequiredDefaultValue() != null && attrValues.contains(attrDef.getRequiredDefaultValue())) {
                    attrValues.remove(attrDef.getRequiredDefaultValue());
                }
                if (attrValues.size() != 0) {
                    a.setValues(attrValues);
                    attributes.add(a);
                    continue;
                }
                attributes.add(a);
                continue;
            }
            if (attrDef.getName().equals(this.searchConfiguration.getLdapIdAttribute())) {
                entityId = values[0];
            }
            if (values[0] == null || attrDef.isRequired() && attrDef.getRequiredDefaultValue() != null && values[0].equals(attrDef.getRequiredDefaultValue())) continue;
            a.setValue(values[0]);
            attributes.add(a);
        }
        try {
            entity = this.internalCreateEntity(entityId, ctx.getNameInNamespace(), attributes);
        }
        catch (NamingException e) {
            entity = null;
            e.printStackTrace();
        }
        return entity;
    }
}

