/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.util.test;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.prefs.util.test.AbstractPrefsSupportedTestCase;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.AuthenticationProviderProxy;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityProvider;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.SecurityProviderImpl;
import org.apache.jetspeed.security.spi.CredentialHandler;
import org.apache.jetspeed.security.spi.GroupSecurityHandler;
import org.apache.jetspeed.security.spi.RoleSecurityHandler;
import org.apache.jetspeed.security.spi.SecurityAccess;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;
import org.apache.jetspeed.security.spi.UserSecurityHandler;

public class AbstractSecurityTestcase
extends AbstractPrefsSupportedTestCase {
    protected SecurityAccess securityAccess;
    protected CredentialHandler ch;
    protected UserSecurityHandler ush;
    protected RoleSecurityHandler rsh;
    protected GroupSecurityHandler gsh;
    protected SecurityMappingHandler smh;
    protected SecurityProvider securityProvider;
    protected UserManager ums;
    protected GroupManager gms;
    protected RoleManager rms;
    protected PermissionManager pms;

    protected void setUp() throws Exception {
        super.setUp();
        this.securityAccess = (SecurityAccess)this.ctx.getBean("org.apache.jetspeed.security.spi.SecurityAccess");
        this.ch = (CredentialHandler)this.ctx.getBean("org.apache.jetspeed.security.spi.CredentialHandler");
        this.ush = (UserSecurityHandler)this.ctx.getBean("org.apache.jetspeed.security.spi.UserSecurityHandler");
        this.rsh = (RoleSecurityHandler)this.ctx.getBean("org.apache.jetspeed.security.spi.RoleSecurityHandler");
        this.gsh = (GroupSecurityHandler)this.ctx.getBean("org.apache.jetspeed.security.spi.GroupSecurityHandler");
        this.smh = (SecurityMappingHandler)this.ctx.getBean("org.apache.jetspeed.security.spi.SecurityMappingHandler");
        AuthenticationProvider atnProvider = (AuthenticationProvider)this.ctx.getBean("org.apache.jetspeed.security.AuthenticationProvider");
        ArrayList<AuthenticationProvider> atnProviders = new ArrayList<AuthenticationProvider>();
        atnProviders.add(atnProvider);
        AuthenticationProviderProxy atnProviderProxy = (AuthenticationProviderProxy)this.ctx.getBean("org.apache.jetspeed.security.AuthenticationProviderProxy");
        this.securityProvider = new SecurityProviderImpl(atnProviderProxy, this.rsh, this.gsh, this.smh);
        this.securityProvider = (SecurityProvider)this.ctx.getBean("org.apache.jetspeed.security.SecurityProvider");
        this.ums = (UserManager)this.ctx.getBean("org.apache.jetspeed.security.UserManager");
        this.gms = (GroupManager)this.ctx.getBean("org.apache.jetspeed.security.GroupManager");
        this.rms = (RoleManager)this.ctx.getBean("org.apache.jetspeed.security.RoleManager");
        this.pms = (PermissionManager)this.ctx.getBean("org.apache.jetspeed.security.PermissionManager");
        new JetspeedActions(new String[]{"secure"}, new String[0]);
    }

    protected Collection getPrincipals(Subject subject, Class claz) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal element = iter.next();
            if (!claz.isInstance(element)) continue;
            principals.add(element);
        }
        return principals;
    }

    protected String[] getConfigurations() {
        String[] confs = super.getConfigurations();
        ArrayList<String> confList = new ArrayList<String>(Arrays.asList(confs));
        confList.add("security-atn.xml");
        confList.add("security-atz.xml");
        confList.add("security-managers.xml");
        confList.add("security-providers.xml");
        confList.add("security-spi.xml");
        confList.add("security-spi-atn.xml");
        confList.add("security-spi-atz.xml");
        return confList.toArray(new String[1]);
    }
}

