/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.ldap.AbstractLdapDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;

public class InitLdapSchema
extends AbstractLdapDao {
    public InitLdapSchema() throws SecurityException {
    }

    public InitLdapSchema(LdapBindingConfig ldapConfig) throws SecurityException {
        super(ldapConfig);
    }

    protected String getObjectClass() {
        return null;
    }

    public void initOu(String ou) throws NamingException {
        if (!StringUtils.isEmpty((String)ou)) {
            Attributes attrs = this.defineLdapAttributes(ou);
            String dn = "ou=" + ou;
            this.ctx.createSubcontext(dn, attrs);
        }
    }

    public void initOu(String ou, String folder) throws NamingException {
        if (!StringUtils.isEmpty((String)ou)) {
            Attributes attrs = this.defineLdapAttributes(ou);
            this.ctx.createSubcontext("ou=" + ou + "," + folder, attrs);
        }
    }

    protected Attributes defineLdapAttributes(String ou) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute classes = new BasicAttribute("objectclass");
        classes.add("top");
        classes.add("organizationalUnit");
        attrs.put(classes);
        attrs.put("ou", ou);
        return attrs;
    }

    protected String getEntryPrefix() {
        return null;
    }

    protected String getSearchSuffix() {
        return null;
    }

    protected String getSearchDomain() {
        return null;
    }

    protected String[] getObjectClasses() {
        return null;
    }

    protected String[] getAttributes() {
        return null;
    }
}

