/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.spi.RoleSecurityHandler;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapRoleDaoImpl;

public class LdapRoleSecurityHandler
implements RoleSecurityHandler {
    private static final Log logger = LogFactory.getLog((Class)LdapRoleSecurityHandler.class);
    private LdapPrincipalDao ldap;

    public LdapRoleSecurityHandler(LdapPrincipalDao ldap) {
        this.ldap = ldap;
    }

    public LdapRoleSecurityHandler() throws NamingException, SecurityException {
        this(new LdapRoleDaoImpl());
    }

    public RolePrincipal getRolePrincipal(String roleFullPathName) {
        String roleUidWithoutSlashes = this.ldap.convertUidToLdapAcceptableName(roleFullPathName);
        this.verifyRoleId(roleUidWithoutSlashes);
        try {
            String dn = this.ldap.lookupByUid(roleUidWithoutSlashes);
            if (!StringUtils.isEmpty((String)dn)) {
                return new RolePrincipalImpl(roleFullPathName);
            }
        }
        catch (SecurityException e) {
            this.logSecurityException(e, roleFullPathName);
        }
        return null;
    }

    public void setRolePrincipal(RolePrincipal rolePrincipal) throws SecurityException {
        this.verifyRolePrincipal(rolePrincipal);
        String fullPath = rolePrincipal.getFullPath();
        String groupUidWithoutSlashes = this.ldap.convertUidToLdapAcceptableName(fullPath);
        if (this.getRolePrincipal(groupUidWithoutSlashes) == null) {
            this.ldap.create(groupUidWithoutSlashes);
        }
    }

    public void removeRolePrincipal(RolePrincipal rolePrincipal) throws SecurityException {
        this.verifyRolePrincipal(rolePrincipal);
        String fullPath = rolePrincipal.getFullPath();
        String roleUidWithoutSlashes = this.ldap.convertUidToLdapAcceptableName(fullPath);
        this.ldap.delete(roleUidWithoutSlashes);
    }

    public List getRolePrincipals(String filter) {
        try {
            return Arrays.asList(this.ldap.find(filter, "/role/"));
        }
        catch (SecurityException e) {
            this.logSecurityException(e, filter);
            return new ArrayList();
        }
    }

    private void verifyRoleId(String rolePrincipalUid) {
        if (StringUtils.isEmpty((String)rolePrincipalUid)) {
            throw new IllegalArgumentException("The roleId cannot be null or empty.");
        }
    }

    private void logSecurityException(SecurityException e, String groupPrincipalUid) {
        if (logger.isErrorEnabled()) {
            logger.error((Object)("An LDAP error has occurred for groupId:" + groupPrincipalUid), (Throwable)e);
        }
    }

    private void verifyRolePrincipal(RolePrincipal rolePrincipal) {
        if (rolePrincipal == null) {
            throw new IllegalArgumentException("The RolePrincipal cannot be null or empty.");
        }
    }
}

